---@class DataPointStore
local classDataPointStore = {
	is_additive = false,
	result = 1,
	reg_factors = {},
	reg_on_changed = {},
}

local __meta = {__index = classDataPointStore}

---Contains many DataPoints
---@param input any
---@return any
--[[

	ExtraClasses.DataPointStore({
		DataPoints = {
			[name] = ExtraClasses.DataPoint(),
		}
	})
]]
function ExtraClasses.DataPointStore(input)
	local self
	if input and input.DataPoints then
		self = input
	elseif type(input) == "table" then
		self.DataPoints = input
	end
	-- copy if it's already setmetatable'd
	if self._on_changed then
		self = table.copy(self)
		if self.DataPoints then
			self.DataPoints = table.copy(self.DataPoints)
		end
	end
	if self.DataPoints then
		for name, datapoint in pairs(self.DataPoints) do
			datapoint = ExtraClasses.DataPoint(datapoint)
		end
	else
		self.DataPoints = {}
	end
	self = setmetatable(self, __meta)
	return self
end
