
---@class TableNumber
local TableNumber = {}
local __meta = {}

-- return sum of all values
function TableNumber:sum()
	local t = 0
	for k, v in pairs(self) do t = t + v end
	return t
end
-- return most positive value
function TableNumber:max()
	local t
	local n
	for k, v in pairs(self) do
		if v >= (t or v) then
			t = v
			n = k
		end
	end
	return t, n
end
-- return most negative value
function TableNumber:min()
	local t
	local n
	for k, v in pairs(self) do
		if v <= (t or v) then
			t = v
			n = k
		end
	end
	return t, n
end
-- return the squared 'distance' from this set to another set `tn`
function TableNumber:square_distance_to(tn)
	local s = 0
	-- get dist from this set's values
	for k, v in pairs(self) do
		s = s + ((tn[k] or 0) - v) ^ 2
	end
	-- get dist from any values this set is missing to the target
	for k, v in pairs(tn) do
		if not self[k] then
			s = s + (v - 0) ^ 2
		end
	end
	return s
end
-- return real distance (root) from this set to set `tn`
function TableNumber:distance_to(tn)
	return math.sqrt(self:square_distance_to(tn))
end

function __meta.__sub(a, b)
	local ret = TableNumber(a)
	for k, v in pairs(a) do ret[k] = v - (b[k] or 0) end
	for k, v in pairs(b) do if not ret[k] then ret[k] = -v end end
	return ret
end
function __meta.__add(a, b)
	local ret = TableNumber(a)
	for k, v in pairs(a) do ret[k] = v + (b[k] or 0) end
	for k, v in pairs(b) do if not ret[k] then ret[k] = v end end
	return ret
end
function __meta.__mul(a, b)
	local ret
	if type(a) == "number" or type(b) == "number" then
		if type(a) == "number" then a,b = b,a end
		ret = TableNumber(a)
		for k, v in pairs(a) do ret[k] = v * (b) end
	else
		ret = TableNumber(a)
		for k, v in pairs(a) do ret[k] = v * (b[k] or 1) end
		for k, v in pairs(b) do if not ret[k] then ret[k] = v end end
	end
	return ret
end
function __meta.__div(a, b)
	local ret = TableNumber(a)
	if type(b) == "number" then
		for k, v in pairs(a) do ret[k] = v / (b or 1) end
	else
		for k, v in pairs(a) do ret[k] = v / (b[k] or 1) end
		for k, v in pairs(b) do if not ret[k] then ret[k] = 1/v end end
	end
	return ret
end
function __meta.__unm(a)
	local ret = TableNumber(a)
	for k, v in pairs(a) do ret[k] = -v end
	return ret
end
function __meta.__mod(a, b)
	local ret = TableNumber(a)
	if type(b) == "number" then
		for k, v in pairs(a) do ret[k] = v % (b or (v+1)) end
	else
		for k, v in pairs(a) do ret[k] = v % (b[k] or (v+1)) end
	end
	return ret
end
function __meta.__pow(a, b)
	local ret = {}
	for k, v in pairs(a) do ret[k] = v ^ (b) end
	return TableNumber(ret)
end
function __meta.__eq(a, b)
	for k, v in pairs(a) do
		if v ~= b[k] then return false end
	end
	return true
end
---@return TableNumber
---@param t table | nil -- must only contain numbers
TableNumber.new = function(t)
	local ret = setmetatable({}, __meta)
	for k, v in pairs(t or {}) do
		ret[k] = v
	end
	return ret
end

__meta.__call = function(self, ...)
	return TableNumber.new(...)
end

__meta.__index = TableNumber

TableNumber = setmetatable({}, __meta)

return TableNumber