
nodeextensions.offset_min = vector.new(-2, -2, -2)
nodeextensions.offset_max = vector.new( 2,  3,  2)

function nodeextensions.on_nearby_get_box(object)
	local pos = object:get_pos()
	return pos + nodeextensions.offset_min, pos + nodeextensions.offset_max
end

function nodeextensions.on_nearby(object, dtime)
	local p1, p2 = nodeextensions.on_nearby_get_box(object)
	local nodes = core.find_nodes_in_area(p1, p2, "group:on_nearby", true)
	for node_name, list in pairs(nodes) do
		local ndef = core.registered_nodes[node_name]
		if ndef then for i, p in ipairs(list) do
			ndef._on_nearby(p, object)
		end end
	end
end

local t = 0
core.register_globalstep(function(dtime)
	if t > 1 then t = t - 1 else t = t + dtime; return end
	for i, player in ipairs(core.get_connected_players()) do
		nodeextensions.on_nearby(player, 1)
	end
end)
