
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = "ash_forest"
local biomes_all = {
	this_biome,
	this_biome.."_OCEAN",
	this_biome.."_underground",
}
local biomes_underground = {
	this_biome.."_OCEAN",
	this_biome.."_underground",
}

aom_mapgen.register_biome({
    name = this_biome,

    node_top = "aom_soil:dirt_with_grass",
    depth_top = 1,

    node_filler = "aom_soil:dirt",
    depth_filler = 5,

    node_riverbed = "aom_soil:sand",
    depth_riverbed = 3,

    y_max = sealevel + 120,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 86,
    humidity_point = 41,
}, {"forest", "ash", "overworld", "flowers", "grass"})

aom_mapgen.register_biome({
	name = this_biome.."_underground",

	y_max = sealevel - 80,
	y_min = alt_min,
	vertical_blend = 8,

    heat_point = core.registered_biomes[this_biome].heat_point,
    humidity_point = core.registered_biomes[this_biome].humidity_point,

	_wind_multiplier = 0,
}, {"overworld", "underground", "grass", "mushrooms"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path

aom_mapgen.add_boulders({
    biomes = {this_biome},
    place_on = {"group:soil", "group:stone"},
    chance = 1,
    height_offset = 0,
    np = {
        offset = -0.01,
        scale = 0.02,
        spread = {x = 10, y = 10, z = 10},
        seed = 64758,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 1.7,
    },
})

-- GIANT ash
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = -0.001,
        scale = 0.0185,
        spread = {x = 100, y = 100, z = 100},
        seed = 64758,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_ash_h19_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 33,
})


-- ash 2
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    -- fill_ratio = 0.001,
    noise_params = {
        offset = -0.004,
        scale = 0.0075,
        spread = {x = 10, y = 10, z = 10},
        seed = 71,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 1.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_ash_h18_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 33,
})

-- ash
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0016,
    -- noise_params = {
    --   offset = -0.004,
    --   scale = 0.0175,
    --   spread = {x = 10, y = 10, z = 10},
    --   seed = 6,
    --   octaves = 8,
    --   persistence = 0.7,
    --   lacunarity = 2.0,
    -- },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_ash_h12_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})


-- also do some OAK trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h14_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -0,
    _layer = 34,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h19_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -0,
    _layer = 33,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h12_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -0,
    _layer = 35,
})
-- bushes
core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 8,
    -- fill_ratio = 0.006,
    biomes = {this_biome},
    noise_params = {
      offset = -0.1,
      scale = 0.2,
      spread = {x = 10, y = 10, z = 10},
      seed = 6,
      octaves = 8,
      persistence = 0.7,
      lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_ash_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
    _layer = 39,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 8,
    -- fill_ratio = 0.006,
    biomes = {this_biome},
    noise_params = {
      offset = -0.1,
      scale = 0.2,
      spread = {x = 10, y = 10, z = 10},
      seed = 6,
      octaves = 8,
      persistence = 0.7,
      lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_ash_bush_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0,
    _layer = 39,
})

-- add dirt with some depth
core.register_decoration({
	deco_type = "simple",
	place_on = {"group:stone"},
	decoration = "aom_soil:clay",

	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -2,
	height = 2,

	sidelen = 4,
	noise_params = {
		offset = -0.7,
		scale = 6.5,
		spread = {x = 16, y = 8, z = 16},
		seed = 45213,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
    _layer = 6,
})
core.register_decoration({
	deco_type = "simple",
	place_on = {"group:stone"},
	decoration = "aom_soil:dirt",

	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -2,
	height = 2,

	sidelen = 4,
	noise_params = {
		offset = -2.9,
		scale = 6.0,
		spread = {x = 16, y = 8, z = 16},
		seed = 5423,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
    _layer = 6,
})
core.register_decoration({
	deco_type = "simple",
	place_on = {"aom_soil:dirt"},
	decoration = "aom_soil:grass",

    fill_ratio = 100,
	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -1,
	height = 1,
    _layer = 6,
})

core.register_decoration({
    deco_type = "simple",
    place_on = {"aom_soil:clay", "aom_soil:grass"},
    decoration = {
        "aom_flora:fern_0", "aom_flora:fern_1",
        "aom_flora:mushroom_glow_yellow_0", "aom_flora:mushroom_glow_yellow_1",
    },

    noise_params = {
        offset = 0.05,
        scale = 0.2,
        spread = {x = 8, y = 8, z = 8},
        seed = 8765,
        octaves = 2,
        persist = 0.6,
        lucanarity = 2.13
    },
    biomes = biomes_underground,
    y_max = alt_max,
    y_min = alt_min,
    flags = "all_floors",
    _layer = 46,
})

core.register_decoration({
    deco_type = "simple",
    place_on = {"aom_soil:clay", "aom_soil:grass"},
    decoration = {
        "aom_flora:mushroom_glow_green_0", "aom_flora:mushroom_glow_green_1",
    },

    noise_params = {
        offset = 0.0,
        scale = 0.05,
        spread = {x = 8, y = 8, z = 8},
        seed = 8765,
        octaves = 2,
        persist = 0.6,
        lucanarity = 2.13
    },
    biomes = biomes_underground,
    y_max = alt_max,
    y_min = alt_min,
    flags = "all_floors",
    _layer = 46,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {"aom_stone:stone"},
	decoration = "aom_mirecaves:nolmera_vine_1",

	sidelen = 8,
	height = 1,
	height_max = 3,
	noise_params = {
		offset = -0.04,
		scale = 0.07,
		spread = {x = 16, y = 4, z = 16},
		seed = 8575,
		octaves = 1,
		persist = 0.1
	},
	y_max = alt_max,
	y_min = alt_min,
	flags = "all_ceilings",
	biomes = biomes_underground,
	_layer = 47,
})
core.register_decoration({
	deco_type = "simple",
	place_on = {"aom_stone:stone"},
	decoration = "aom_mirecaves:nolmera_vine_1",

	sidelen = 4,
	height = 1,
	height_max = 5,
	noise_params = {
		offset = -0.18,
		scale = 0.3,
		spread = {x = 16, y = 2, z = 16},
		seed = 45245,
		octaves = 1,
		persist = 0.1
	},
	y_max = alt_max,
	y_min = alt_min,
	flags = "all_ceilings",
	biomes = biomes_underground,
	_layer = 47,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {
        "aom_stone:cobble_moss_1", "aom_stone:cobble_moss_2",
        "aom_stone:stone", "aom_stone:cobble",
    },
	sidelen = 4,
	noise_params = {
		offset = -0.2,
		scale = 0.5,
		spread = {x = 16, y = 16, z = 16},
		seed = 7534,
		octaves = 4,
		persist = 0.2,
		lacunarity = 2.00,
	},
	biomes = biomes_underground,
	y_max = alt_max,
	y_min = alt_min,
	decoration = "aom_spawnnodes:mossy_rubble",
    flags = "all_floors",
    _layer = 47,
})
