
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'grasslands'
local biomes_all = {
	this_biome,
	this_biome.."_OCEAN",
	this_biome.."_underground",
}
local biomes_underground = {
	this_biome.."_OCEAN",
	this_biome.."_underground",
}

aom_mapgen.register_biome({
    name = this_biome,

    node_top = 'aom_soil:dirt_with_grass',
    depth_top = 1,

    node_filler = 'aom_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 200,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 49,
    humidity_point = 46,
}, {"field", "overworld", "clearing", "flowers", "grass"})

aom_mapgen.register_biome({
	name = this_biome.."_underground",

	y_max = sealevel - 80,
	y_min = alt_min,
	vertical_blend = 8,

    heat_point = 49,
    humidity_point = 46,

	_wind_multiplier = 0,
}, {"overworld", "underground", "mushrooms", "grass", "flowers"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path

local size = 100
-- GRASS VAR 4
core.register_ore({
        ore_type	= "stratum",
        ore		    = "aom_soil:grass_variant_4",
        wherein		= {"group:topsoil"},
        y_min = sealevel-20,
        y_max = sealevel+200,
        clust_scarcity    = 1,
        noise_params        = {
                offset = sealevel+10,
                scale = 200,
                spread = {x = size, y = size, z = size},
                seed = 354387,
                octaves = 3,
                lacunarity = 3,
        },
        np_stratum_thickness = {
                offset = -20,
                scale = 250,
                spread = {x = 100, y = 100, z = 100},
                seed = 89567864,
                octaves = 2,
                lacunarity = 3,
                persistence = 0.2
        },
        stratum_thickness = 20,
        biomes = {this_biome},
})


local tree_np = {
    offset = -0.0015,
    scale = 0.003,
    spread = {x = 16, y = 16, z = 16},
    seed = 5546,
    octaves = 2,
    persist = 0.2,
    lacunarity = 2.00,
}
-- huge oak
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h23_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 33,
})
-- huge oak
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h12_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h10_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 36,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h12_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})

-- sparse trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h14_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})

-- sparse trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h10_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 36,
})


local bush_np = {
    offset = -0.0015,
    scale = 0.005,
    spread = {x = 16, y = 16, z = 16},
    seed = 10843,
    octaves = 1,
    persist = 0.2,
    lacunarity = 2.00,
}
-- bushes in large sparse clumps
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 4,
    noise_params = bush_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
    _layer = 39,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 4,
    noise_params = bush_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_bush_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
    _layer = 39,
})
core.register_decoration({
    deco_type = "simple",
    place_on = {"group:soil"},
    sidelen = 4,
    noise_params = bush_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    decoration = "aom_flora:shrub_1",
    _layer = 44,
})
-- huge oak
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h19_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 34,
})

-- do return end
-- UNDERGROUND
local u_grass = "aom_soil:grass"
local u_grass_1 = "aom_soil:grass_variant_1"
local u_grass_2 = "aom_soil:grass_variant_2"
local u_grass_3 = "aom_soil:grass_variant_3"

-- add dirt with some depth
core.register_decoration({
	deco_type = "simple",
	place_on = {"group:stone"},
	decoration = "aom_soil:dirt",

	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -3,
	height = 3,

	sidelen = 4,
	noise_params = {
		offset = -1.0,
		scale = 6.5,
		spread = {x = 16, y = 8, z = 16},
		seed = 45213,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
    _layer = 6,
})

-- fill topsoil with grass node
core.register_decoration({
	deco_type = "simple",
	place_on = {"aom_soil:dirt"},
	decoration = u_grass,

	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -1,
    fill_ratio = 100,
	height = 1,
    _layer = 6,
})

-- flowery grass
core.register_decoration({
	deco_type = "simple",
	place_on = {u_grass},
	decoration = u_grass_2,

	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -1,
	height = 1,

	sidelen = 8,
	noise_params = {
		offset = 0.2,
		scale = 1.2,
		spread = {x = 16, y = 8, z = 16},
		seed = 34,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
    _layer = 6,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {u_grass},
	decoration = {u_grass_1, u_grass_1, u_grass_3},

	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -1,
	height = 1,

	sidelen = 8,
	noise_params = {
		offset = 0.2,
		scale = 0.3,
		spread = {x = 8, y = 8, z = 8},
		seed = 63,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
    _layer = 6,
})

core.register_decoration({
    deco_type = "simple",
    place_on = {u_grass, u_grass_1, u_grass_1, u_grass_3},
    decoration = {"aom_flora:mushroom_glow_blue_0", "aom_flora:mushroom_glow_blue_1"},

    noise_params = {
        offset = 0.05,
        scale = 0.2,
        spread = {x = 8, y = 8, z = 8},
        seed = 4563,
        octaves = 2,
        persist = 0.6,
        lucanarity = 2.13
    },
    biomes = biomes_underground,
    y_max = alt_max,
    y_min = alt_min,
    flags = "all_floors",
    _layer = 46,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {
        "group:topsoil", "aom_stone:cobble_moss_1", "aom_stone:cobble_moss_2",
        "aom_stone:stone", "aom_stone:cobble",
    },
	sidelen = 4,
	noise_params = {
		offset = -0.2,
		scale = 0.5,
		spread = {x = 16, y = 16, z = 16},
		seed = 7534,
		octaves = 4,
		persist = 0.2,
		lacunarity = 2.00,
	},
	biomes = biomes_underground,
	y_max = alt_max,
	y_min = alt_min,
	decoration = "aom_spawnnodes:mossy_rubble",
    flags = "all_floors",
    _layer = 47,
})

core.register_decoration({
    deco_type = "simple",
    place_on = {"group:topsoil", "group:stone"},
    decoration = {
        "aom_flora:mushroom_glow_green_0", "aom_flora:mushroom_glow_green_1",
    },

    noise_params = {
        offset = -0.08,
        scale = 0.12,
        spread = {x = 8, y = 8, z = 8},
        seed = 8765,
        octaves = 2,
        persist = 0.6,
        lucanarity = 2.13
    },
    biomes = biomes_all,
    y_max = sealevel,
    y_min = alt_min,
    flags = "all_floors",
    _layer = 46,
})
