
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'oak_forest_dense_border'

aom_mapgen.register_biome({
    name = this_biome,

    node_top = 'aom_soil:forest_dirt',
    depth_top = 1,

    node_filler = 'aom_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 120,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 83,
    humidity_point = 78,
}, {"forest", "oak", "overworld", "grass"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path


-- lots of bunched up trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = -0.0,
        scale = 0.03,
        spread = {x = 1, y = 150, z = 1},
        seed = 654,
        octaves = 4,
        persist = 0.1
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h14_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})
-- GIANT oaks
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = -0.0,
        scale = 0.03,
        spread = {x = 1, y = 150, z = 1},
        seed = 8976,
        octaves = 4,
        persist = 0.1
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h12_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})
-- GIANT oaks
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h19_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -3,
    _layer = 34,
})
-- really huge tree
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h23_0"),
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
    place_offset_y = -0,
    _layer = 34,
})


-- bushes in large sparse clumps
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = -0.0,
        scale = 0.03,
        spread = {x = 1, y = 150, z = 1},
        seed = 867,
        octaves = 4,
        persist = 0.1
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
    _layer = 39,
})



-- FOREST GRASS
core.register_ore({
    ore_type	= "blob",
    ore		    = "aom_soil:dirt_with_grass",
    wherein		= {"aom_soil:forest_dirt"},
    clust_scarcity	= 150,
    clust_num_ores	= 5,
    clust_size	= 7,
    y_min		= -100,
    y_max		= 3000,
    noise_params = {
        offset  = 0.005,
        scale   = 1,
        spread  = {x=250, y=250, z=250},
        seed    = 12345,
        octaves = 3,
        persist = 0.6,
        lacunarity = 2,
        flags = "defaults",
    },
    biomes = {this_biome},
})

core.register_ore({
    ore_type	= "scatter",
    ore		    = "aom_soil:forest_grass",
    wherein		= {"aom_soil:forest_dirt"},
    clust_scarcity	= 250,
    clust_num_ores	= 40,
    clust_size	= 7,
    y_min		= -100,
    y_max		= 3000,
    biomes = {this_biome},
})
core.register_ore({
    ore_type	= "scatter",
    ore		    = "aom_stone:stone",
    wherein		= {"group:soil"},
    clust_scarcity	= 1050,
    clust_num_ores	= 20,
    clust_size	= 3,
    y_min		= -3,
    y_max		= 3000,
    biomes = {this_biome},
})


core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = 0,
        scale = 0.0015,
        spread = {x = 50, y = 200, z = 50},
        seed = 354,
        octaves = 2,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_ash_h12_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})

core.register_decoration({
    deco_type = "simple",
    place_on = {"group:topsoil"},
    decoration = {
        "aom_flora:mushroom_glow_green_0", "aom_flora:mushroom_glow_green_1",
    },

    noise_params = {
        offset = -0.08,
        scale = 0.12,
        spread = {x = 8, y = 8, z = 8},
        seed = 8765,
        octaves = 2,
        persist = 0.6,
        lucanarity = 2.13
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = alt_min,
    flags = "all_floors",
    _layer = 46,
})
