
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = "ruined_valley"
local biomes_all = {
	this_biome,
	this_biome.."_OCEAN",
	this_biome.."_underground",
}
local biomes_underground = {
	this_biome.."_OCEAN",
	this_biome.."_underground",
}

aom_mapgen.register_biome({
    name = this_biome,

    node_top = "aom_soil:grass",
    depth_top = 1,

    node_filler = "aom_soil:dirt",
    depth_filler = 5,

    node_riverbed = "aom_soil:sand",
    depth_riverbed = 3,

    y_max = sealevel + 20,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 2,

    heat_point = 41,
    humidity_point = 79,
}, {"light_scrub", "spruce", "ruin", "overworld", "shore"})

aom_mapgen.register_biome({
	name = this_biome.."_underground",

	y_max = sealevel - 80,
	y_min = alt_min,
	vertical_blend = 8,

    heat_point = 41,
    humidity_point = 79,

	_wind_multiplier = 0,
}, {"spruce", "ruin", "overworld", "underground", "mushrooms"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path


-- ORES

local size = 100
-- GRASS VAR 4
core.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_soil:grass_variant_4",
    wherein		= {"group:topsoil"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 354387,
        octaves = 4,
        lacunarity = 3,
    },
    np_stratum_thickness = {
        offset = 20,
        scale = 240,
        spread = {x = 100, y = 100, z = 100},
        seed = 89567864,
        octaves = 4,
        lacunarity = 3,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})

size = 30
core.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_soil:forest_grass_1",
    wherein		= {"group:topsoil"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 5643,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = 50,
        scale = 240,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 4,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})
core.register_ore({
    ore_type	= "stratum",
    ore		    = "aom_soil:forest_grass_2",
    wherein		= {"aom_soil:forest_grass_1"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 5643,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = 0,
        scale = 190,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 5,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})



aom_mapgen.add_ruins({this_biome}, 0.5)



-- trees
if true then
-- oak

-- lots of bunched up trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.01,
        scale = 0.0035,
        spread = {x = 50, y = 50, z = 50},
        seed = 354,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_tall_h28_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
        offset = 0.01,
        scale = 0.0035,
        spread = {x = 50, y = 50, z = 50},
        seed = 234,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_tall_h23_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


-- boulders
core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_boulder_small_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_boulder_small_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_boulder_small_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
end


local function do_grasses(name, seed, def)
    def = def or {}
    core.register_decoration({
        deco_type = "simple",
        place_on = def.place_on or {"aom_soil:grass"},
        noise_params = {
            offset = def.offset or -0.11,
            scale = def.scale or 0.19,
            spread = {x = 20, y = 20, z = 20},
            seed = seed,
            octaves = 1,
            persist = 1.2
        },
        biomes = def.biomes or {this_biome},
        y_max = def.y_max or alt_max,
        y_min = def.y_min or (sealevel-20),
        decoration = name,
        flags = "all_floors",
        _layer = 46,
    })
end

do_grasses("aom_flora:fern_0", 6546)
do_grasses("aom_flora:fern_1", 6546)
do_grasses("aom_flora:fern_0", 6546)
do_grasses("aom_flora:fern_1", 6546)


do_grasses("aom_flora:grass_0", 43)
do_grasses("aom_flora:grass_0", 43)
do_grasses("aom_flora:grass_1", 43)
do_grasses("aom_flora:grass_1", 43)


core.register_decoration({
    deco_type = "simple",
    place_on = {"aom_soil:grass"},
    noise_params = {
        offset = -0.49,
        scale = 0.53,
        spread = {x = 2, y = 2, z = 2},
        seed = 9087,
        octaves = 1,
        persist = 1.2
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    decoration = "aom_flora:potato_2",
    _layer = 46,
})
core.register_decoration({
    deco_type = "simple",
    place_on = {"aom_soil:grass"},
    noise_params = {
        offset = -0.49,
        scale = 0.53,
        spread = {x = 2, y = 2, z = 2},
        seed = 9087,
        octaves = 1,
        persist = 1.2
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    decoration = "aom_flora:potato_3",
    _layer = 46,
})


-- UNDERGROUND
local u_grass_1 = "aom_soil:forest_grass_1"
local u_grass_2 = "aom_soil:forest_grass_2"
local u_grass_3 = "aom_soil:forest_grass_3"

-- add dirt with some depth
core.register_decoration({
	deco_type = "simple",
	place_on = {"group:stone"},
	decoration = "aom_soil:dirt",

	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -3,
	height = 3,

	sidelen = 4,
	noise_params = {
		offset = -1.0,
		scale = 6.5,
		spread = {x = 16, y = 8, z = 16},
		seed = 45213,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
    _layer = 6,
})

-- fill topsoil with grass node
core.register_decoration({
	deco_type = "simple",
	place_on = {"aom_soil:dirt"},
	decoration = u_grass_1,

	biomes = biomes_underground,
	y_max = sealevel,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -1,
    fill_ratio = 100,
	height = 1,
    _layer = 6,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {u_grass_1},
	decoration = u_grass_2,

	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -1,
	height = 1,

	sidelen = 4,
	noise_params = {
		offset = 2.0,
		scale = 6.5,
		spread = {x = 16, y = 8, z = 16},
		seed = 34,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
    _layer = 6,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {u_grass_1, u_grass_2},
	decoration = u_grass_3,

	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
    flags = "all_floors, force_placement",
    place_offset_y = -1,
	height = 1,

	sidelen = 4,
	noise_params = {
		offset = -1.0,
		scale = 6.5,
		spread = {x = 16, y = 8, z = 16},
		seed = 8765,
		octaves = 2,
		persist = 0.8,
		lacunarity = 2.00,
	},
    _layer = 6,
})

core.register_decoration({
    deco_type = "simple",
    place_on = {"group:stone"},
    decoration = {"aom_flora:glowroot_plant_2", "aom_flora:glowroot_plant_4"},

    noise_params = {
        offset = -0.1,
        scale = 0.19,
        spread = {x = 12, y = 4, z = 12},
        seed = 7984,
        octaves = 2,
        persist = 0.6,
        lucanarity = 2.13
    },
    biomes = biomes_underground,
    y_max = alt_max,
    y_min = alt_min,
    flags = "all_floors",
    _layer = 46,
})

local opts = {biomes = biomes_all, y_min = alt_min, offset = 0.1, scale = 0.1, place_on = {"aom_soil:forest_grass_3"}}
do_grasses("aom_flora:grass_0", 43, opts)
do_grasses("aom_flora:grass_1", 43, opts)

opts = {biomes = biomes_all, y_min = alt_min, offset = 0.07, place_on = {"aom_soil:forest_grass_1", "aom_soil:forest_grass_2"}}
do_grasses("aom_flora:fern_0", 6546, opts)
do_grasses("aom_flora:fern_1", 6546, opts)


core.register_decoration({
    deco_type = "simple",
    place_on = {u_grass_1, u_grass_2, u_grass_3},
    decoration = {"aom_flora:mushroom_glow_yellow_0", "aom_flora:mushroom_glow_yellow_1"},

    noise_params = {
        offset = 0.05,
        scale = 0.2,
        spread = {x = 8, y = 8, z = 8},
        seed = 4563,
        octaves = 2,
        persist = 0.6,
        lucanarity = 2.13
    },
    biomes = biomes_underground,
    y_max = alt_max,
    y_min = alt_min,
    flags = "all_floors",
    _layer = 46,
})


-- spawnnodes
core.register_decoration({
	deco_type = "simple",
	place_on = {"group:stone"},
	sidelen = 4,
	noise_params = {
		offset = -0.15,
		scale = 0.5,
		spread = {x = 24, y = 8, z = 24},
		seed = 8567,
		octaves = 3,
		persist = 0.2,
		lacunarity = 2.00,
	},
	biomes = {this_biome},
	y_max = alt_max,
	y_min = sealevel,
	decoration = "aom_spawnnodes:concerning_clover",
    flags = "all_floors",
    _layer = 47,
})

core.register_decoration({
	deco_type = "simple",
	place_on = {"group:topsoil", "group:stone"},
	sidelen = 4,
	noise_params = {
		offset = -0.15,
		scale = 0.5,
		spread = {x = 24, y = 8, z = 24},
		seed = 8567,
		octaves = 3,
		persist = 0.2,
		lacunarity = 2.00,
	},
	biomes = biomes_underground,
	y_max = sealevel-1,
	y_min = alt_min,
	decoration = "aom_spawnnodes:concerning_clover",
    flags = "all_floors",
    _layer = 47,
})

