
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

if aom_mapgen.biome_groups.flowers ~= nil then

local o = 0.02
local p = 0.1

core.register_decoration({
    name = "aom_flora:flower_red",
    deco_type = "simple",
    place_on = {"group:topsoil"}, -- only on grasslike nodes
    sidelen = 16,
    noise_params = {
        offset = -p + o,
        scale = p,
        spread = {x = 7, y = 7, z = 7},
        seed = 9886,
        octaves = 3,
        persist = 0.2
    },
    biomes = aom_mapgen.biome_groups.flowers,
    y_max = alt_max,
    y_min = sealevel + 1,
    decoration = "aom_flora:flower_red",
    _layer = 46,
})

core.register_decoration({
    name = "aom_flora:flower_white",
    deco_type = "simple",
    place_on = {"group:topsoil"}, -- only on grasslike nodes
    sidelen = 16,
    noise_params = {
        offset = -p + o,
        scale = p,
        spread = {x = 7, y = 7, z = 7},
        seed = 9886,
        octaves = 3,
        persist = 0.2
    },
    biomes = aom_mapgen.biome_groups.flowers,
    y_max = alt_max,
    y_min = sealevel + 1,
    decoration = "aom_flora:flower_white",
    _layer = 46,
})

core.register_decoration({
    name = "aom_flora:flower_yellow",
    deco_type = "simple",
    place_on = {"group:topsoil"}, -- only on grasslike nodes
    sidelen = 16,
    noise_params = {
        offset = -p + o,
        scale = p,
        spread = {x = 7, y = 7, z = 7},
        seed = 9886,
        octaves = 3,
        persist = 0.2
    },
    biomes = aom_mapgen.biome_groups.flowers,
    y_max = alt_max,
    y_min = sealevel + 1,
    decoration = "aom_flora:flower_yellow",
    _layer = 46,
})

end