
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min


core.register_decoration({
    -- name = "aom_flora:mushroom_red",
    deco_type = "simple",
    place_on = {"aom_soil:forest_grass"}, -- only on grasslike nodes
    sidelen = 16,
    noise_params = {
        offset = -0.002,
        scale = 0.06,
        spread = {x = 20, y = 20, z = 20},
        seed = 4654,
        octaves = 3,
        persist = 0.2
    },
    biomes = aom_mapgen.biome_groups.mushrooms,
    y_max = alt_max,
    y_min = alt_min,
    decoration = "aom_flora:mushroom_red",
    flags = "all_floors",
})

core.register_decoration({
    -- name = "aom_flora:mushroom_brown",
    deco_type = "simple",
    place_on = {"aom_soil:forest_grass"}, -- only on grasslike nodes
    sidelen = 16,
    noise_params = {
        offset = -0.002,
        scale = 0.06,
        spread = {x = 20, y = 20, z = 20},
        seed = 54,
        octaves = 3,
        persist = 0.2
    },
    biomes = aom_mapgen.biome_groups.mushrooms,
    y_max = alt_max,
    y_min = alt_min,
    decoration = "aom_flora:mushroom_brown",
    flags = "all_floors",
    _layer = 46,
})

core.register_decoration({
    -- name = "aom_flora:mushroom_white",
    deco_type = "simple",
    place_on = {"aom_soil:forest_grass"}, -- only on grasslike nodes
    sidelen = 16,
    noise_params = {
        offset = -0.225,
        scale = 0.29,
        spread = {x = 20, y = 20, z = 20},
        seed = 54,
        octaves = 3,
        persist = 0.2
    },
    biomes = aom_mapgen.biome_groups.mushrooms,
    y_max = alt_max,
    y_min = alt_min,
    decoration = "aom_flora:mushroom_white",
    flags = "all_floors",
    _layer = 46,
})


-- core.log(dump(aom_mapgen.biome_groups))

core.register_decoration({
    deco_type = "simple",
    place_on = {"group:topsoil"}, -- only on grasslike nodes
    sidelen = 4,
    noise_params = {
        offset = -0.6,
        scale = 0.8,
        spread = {x = 2, y = 20, z = 2},
        seed = 4654,
        octaves = 3,
        persist = 0.2
    },
    biomes = aom_mapgen.biome_groups.mushrooms_dense,
    y_max = alt_max,
    y_min = alt_min,
    decoration = "aom_flora:mushroom_red",
    flags = "all_floors",
    _layer = 46,
})

core.register_decoration({
    deco_type = "simple",
    place_on = {"group:topsoil"}, -- only on grasslike nodes
    sidelen = 4,
    noise_params = {
        offset = -0.6,
        scale = 0.8,
        spread = {x = 2, y = 20, z = 2},
        seed = 54,
        octaves = 3,
        persist = 0.2
    },
    biomes = aom_mapgen.biome_groups.mushrooms_dense,
    y_max = alt_max,
    y_min = alt_min,
    decoration = "aom_flora:mushroom_brown",
    flags = "all_floors",
    _layer = 46,
})

core.register_decoration({
    deco_type = "simple",
    place_on = {"group:topsoil"}, -- only on grasslike nodes
    sidelen = 4,
    noise_params = {
        offset = -0.6,
        scale = 0.8,
        spread = {x = 2, y = 20, z = 2},
        seed = 54,
        octaves = 3,
        persist = 0.2
    },
    biomes = aom_mapgen.biome_groups.mushrooms_dense,
    y_max = alt_max,
    y_min = alt_min,
    decoration = "aom_flora:mushroom_white",
    flags = "all_floors",
    _layer = 46,
})
