
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

function aom_mapgen.register_ores_for_node(in_node, flags)
    flags = flags or {}
    flags.skip = flags.skip or {}
    local ore_mult = flags.ore_mult or aom_vars.overworld.ore_multiplier

    -- coal
    if not flags.skip.coal then
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_coal_ore",
        wherein        = {in_node},
        clust_scarcity = 209050 / ore_mult,
        clust_num_ores = 100,
        clust_size     = 8,
        y_min = alt_min,
        y_max = sealevel - 60,
    })
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_coal_ore",
        wherein        = {in_node},
        clust_scarcity = 10900 / ore_mult,
        clust_num_ores = 20,
        clust_size     = 9,
        y_min = alt_min,
        y_max = sealevel,
    })
    -- more coal in the mid range to help new players
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_coal_ore",
        wherein        = {in_node},
        clust_scarcity = 850 / ore_mult,
        clust_num_ores = 5,
        clust_size     = 3,
        y_min = sealevel - 10,
        y_max = sealevel + 100,
    })
    end

    -- IRON
    if not flags.skip.iron then
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_iron_ore",
        wherein        = {in_node},
        clust_scarcity = 1000 / ore_mult,
        clust_num_ores = 2,
        clust_size     = 2,
        y_min = sealevel,
        y_max = alt_max,
    })
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_iron_ore",
        wherein        = {in_node},
        clust_scarcity = 1600 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 2,
        y_min = sealevel + 50,
        y_max = alt_max,
    })
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_iron_ore",
        wherein        = {in_node},
        clust_scarcity = 1000 / ore_mult,
        clust_num_ores = 8,
        clust_size     = 3,
        y_min = alt_min,
        y_max = sealevel,
    })
    end



    -- TIN
    if not flags.skip.tin then
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_tin_ore",
        wherein        = {in_node},
        clust_scarcity = 4000 / ore_mult,
        clust_num_ores = 8,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel + 10,
    })
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_tin_ore",
        wherein        = {in_node},
        clust_scarcity = 3500 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 3,
        y_min = alt_min,
        y_max = alt_max,
    })
    end


    -- COPPER
    if not flags.skip.copper then
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_copper_ore",
        wherein        = {in_node},
        clust_scarcity = 2500 / ore_mult,
        clust_num_ores = 8,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel + 20,
    })
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_copper_ore",
        wherein        = {in_node},
        clust_scarcity = 3500 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 3,
        y_min = alt_min,
        y_max = alt_max,
    })
    end


    -- LAPIS
    if not flags.skip.lapis then
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_lapis_ore",
        wherein        = {in_node},
        clust_scarcity = 5000 / ore_mult,
        clust_num_ores = 5,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel - 40,
    })
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_lapis_ore",
        wherein        = {in_node},
        clust_scarcity = 3500 / ore_mult,
        clust_num_ores = 2,
        clust_size     = 4,
        y_min = sealevel + 300,
        y_max = alt_max,
    })
    end


    -- GOLD
    if not flags.skip.gold then
    core.register_ore({
        ore_type       = "scatter",
        -- ore            = "aom_util:light_node_14",
        ore            = (flags.node_prefix or in_node).."_gold_ore",
        wherein        = {in_node},
        clust_scarcity = 3500 / ore_mult,
        clust_num_ores = 6,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel - 40,
    })
    core.register_ore({
        ore_type       = "scatter",
        -- ore            = "aom_util:light_node_14",
        ore            = (flags.node_prefix or in_node).."_gold_ore",
        wherein        = {in_node},
        clust_scarcity = 5000 / ore_mult,
        clust_num_ores = 16,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel - 200,
    })
    core.register_ore({
        ore_type       = "scatter",
        -- ore            = "aom_util:light_node_14",
        ore            = (flags.node_prefix or in_node).."_gold_ore",
        wherein        = {in_node},
        clust_scarcity = 7000 / ore_mult,
        clust_num_ores = 7,
        clust_size     = 3,
        y_min = sealevel - 6,
        y_max = sealevel + 6,
    })
    core.register_ore({
        ore_type       = "scatter",
        -- ore            = "aom_util:light_node_14",
        ore            = (flags.node_prefix or in_node).."_gold_ore",
        wherein        = {in_node},
        clust_scarcity = 3500 / ore_mult,
        clust_num_ores = 3,
        clust_size     = 4,
        y_min = sealevel + 300,
        y_max = alt_max,
    })
    end


    -- DIAMOND
    if not flags.skip.diamond then
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_diamond_ore",
        wherein        = {in_node},
        clust_scarcity = 3300 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel - 50,
    })
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_diamond_ore",
        wherein        = {in_node},
        clust_scarcity = 200000 / ore_mult,
        clust_num_ores = 1,
        clust_size     = 1,
        y_min = alt_min,
        y_max = alt_max,
    })
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_diamond_ore",
        wherein        = {in_node},
        clust_scarcity = 4650 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 3,
        y_min = sealevel + math.abs(alt_max - sealevel) * 0.6,
        y_max = alt_max,
    })
    end

    -- IGNIS
    if not flags.skip.ignis then
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_ignis_ore",
        wherein        = {in_node},
        clust_scarcity = 3000 / ore_mult,
        clust_num_ores = 8,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel - 50,
    })
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_ignis_ore",
        wherein        = {in_node},
        clust_scarcity = 5000 / ore_mult,
        clust_num_ores = 8,
        clust_size     = 3,
        y_min = alt_min,
        y_max = sealevel - 10,
    })
    core.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_ignis_ore",
        wherein        = {in_node},
        clust_scarcity = 4000 / ore_mult,
        clust_num_ores = 7,
        clust_size     = 3,
        y_min = sealevel + 200,
        y_max = alt_max,
    })
    core.register_ore({
        ore_type       = "scatter",
        ore            = "aom_stone:ignis_block",
        wherein        = {(flags.node_prefix or in_node).."_ignis_ore"},
        clust_scarcity = 30 / ore_mult,
        clust_num_ores = 1,
        clust_size     = 1,
        y_min = alt_min,
        y_max = alt_max,
    })
    end
end

aom_mapgen.register_ores_for_node("aom_stone:stone")
aom_mapgen.register_ores_for_node("aom_stone:sandstone")
aom_mapgen.register_ores_for_node("aom_stone:limestone")
aom_mapgen.register_ores_for_node("aom_stone:granite")
aom_mapgen.register_ores_for_node("aom_stone:loose_stone")

aom_mapgen.register_ores_for_node("aom_soil:sand", {
    skip = {diamond=1, lapis=1, coal=1},
    ore_mult = 0.1,
})
aom_mapgen.register_ores_for_node("aom_soil:dirt", {
    skip = {coal=1},
    ore_mult = 0.7,
})
