local sch = aom_sch.get_schematic_path



function aom_mapgen.add_boulders(def)
    core.register_decoration({
        deco_type = "schematic",
        place_on = def.place_on or {"group:soil", "group:stone"},
        sidelen = def.sidelen or 8,
        fill_ratio = 0.0007 * (def.chance or 1),
        noise_params = def.np or nil,
        biomes = def.biomes,
        y_min = -10,
        y_max = 200,
        schematic = sch("aom_boulder_0"),
        flags = "place_center_x, place_center_z, force_placement",
        rotation = "random",
        place_offset_y = -2 + (def.height_offset or 0),
        _layer = 16,
    })
    core.register_decoration({
        deco_type = "schematic",
        place_on = def.place_on or {"group:soil", "group:stone"},
        sidelen = def.sidelen or 8,
        fill_ratio = 0.0007 * (def.chance or 1),
        noise_params = def.np or nil,
        biomes = def.biomes,
        y_min = -10,
        y_max = 200,
        schematic = sch("aom_boulder_1"),
        flags = "place_center_x, place_center_z, force_placement",
        rotation = "random",
        place_offset_y = -2 + (def.height_offset or 0),
        _layer = 16,
    })
    core.register_decoration({
        deco_type = "schematic",
        place_on = def.place_on or {"group:soil", "group:stone"},
        sidelen = def.sidelen or 8,
        fill_ratio = 0.0007 * (def.chance or 1),
        noise_params = def.np or nil,
        biomes = def.biomes,
        y_min = -10,
        y_max = 200,
        schematic = sch("aom_boulder_2"),
        flags = "place_center_x, place_center_z, force_placement",
        rotation = "random",
        place_offset_y = -5 + (def.height_offset or 0),
        _layer = 16,
    })
    core.register_decoration({
        deco_type = "schematic",
        place_on = def.place_on or {"group:soil", "group:stone"},
        sidelen = def.sidelen or 8,
        fill_ratio = 0.0007 * (def.chance or 1),
        noise_params = def.np or nil,
        biomes = def.biomes,
        y_min = -10,
        y_max = 200,
        schematic = sch("aom_boulder_3"),
        flags = "place_center_x, place_center_z, force_placement",
        rotation = "random",
        place_offset_y = -7 + (def.height_offset or 0),
        _layer = 16,
    })
end
