
local adjacent = {
	vector.new( 1, 0, 0),
	vector.new(-1, 0, 0),
	vector.new( 0, 0, 1),
	vector.new( 0, 0,-1),
	vector.new( 0,-1, 0),
}

local has_init = false
local water_cids = {}
local mapgen_stone

local data = {}
local after_generated = function(vmanip, minp, maxp, blockseed)
	if not has_init then
		for name, ndef in pairs(core.registered_nodes) do
			if ndef.liquidtype == "source" then
				local cid = core.get_content_id(name)
				water_cids[cid] = true
			end
		end
		mapgen_stone = core.get_content_id("mapgen_stone")
	end
	local AIR = core.get_content_id("air")
	local emin, emax = vmanip:get_emerged_area()
	local area = VoxelArea:new{MinEdge = emin, MaxEdge = emax}
	vmanip:get_data(data)
	for di in area:iterp(minp, maxp) do
		if water_cids[data[di]] then
			local pos = area:position(di)
			for i, p in ipairs(adjacent) do
				local d = pos + p
				local adj_i = area:indexp(d)
				if data[adj_i] == AIR then
					data[di] = mapgen_stone
					break
				end
			end
		end
	end
	vmanip:set_data(data)
	vmanip:calc_lighting()
end

core.register_on_generated(after_generated)
