local S = minetest.get_translator(minetest.get_current_modname())


sum_air_currents = {
  wind_yaw = 3.14,
  wind_dir = vector.new(0,0,0),
  wind_speed = 0,
  wind_change_mult = 1,
  max_wind_speed = 10,
  wind = vector.new(0,0,0),
  wind_target = 10,
  player_particles = false,
  push_players = false,
  player_particles_threshold = 0.3,
  stillness_chance = 0.1,
  push_entities = false,
  enabled = true,
}

sum_air_currents.get_light = function(pos)
  local ret = 0
  if minetest.get_natural_light then
    ret = minetest.get_natural_light(pos)
  else
    ret = minetest.get_light(pos, 0.5)
  end
  if not ret then ret = 0 end
  return ret
end


local ac = sum_air_currents

dofile(minetest.get_modpath("sum_air_currents") .. DIR_DELIM .. "particles.lua")
dofile(minetest.get_modpath("sum_air_currents") .. DIR_DELIM .. "commands.lua")

ac.wind_change_mult = tonumber(minetest.settings:get("wind_change_mult") or ac.wind_change_mult)
ac.stillness_chance = tonumber(minetest.settings:get("wind_stillness_chance") or ac.stillness_chance)
ac.player_particles = minetest.settings:get_bool("wind_player_particles") ~= false
ac.push_players = minetest.settings:get_bool("wind_push_players") ~= false
ac.push_entities = minetest.settings:get_bool("wind_push_entities") ~= false

local clamp = function(num, min, max)
  return (math.min(math.max(num, min), max))
end

local globalstep_timer = 1 -- start immediately
ac.timers = {
  change_dir = {time = 0, trigger = 1, func = nil, trigger_min = 30, trigger_max = 120},
}
ac.timers.change_dir.trigger_min = tonumber(minetest.settings:get("wind_change_time_min") or ac.timers.change_dir.trigger_min)
ac.timers.change_dir.trigger_max = tonumber(minetest.settings:get("wind_change_time_max") or ac.timers.change_dir.trigger_max)

ac.timers.change_dir.func = function()
  ac.wind_yaw = math.random(0, 100) * math.pi * 2 / 100
  ac.wind_dir = minetest.yaw_to_dir(ac.wind_yaw)
  ac.wind_speed = 0
  if math.random(0, 1) < ac.stillness_chance then
    ac.wind_target = 0
  else
    ac.wind_target = ((math.random(0, (ac.max_wind_speed) ^ 2) * 100) / 100) / ac.max_wind_speed
  end
  ac.wind_change_mult = math.random(0.1, 20)
  ac.timers.change_dir.time = 0
end

sum_air_currents.on_step = function(dtime)
  if not ac.enabled then return end
  -- only do it once a second
  if globalstep_timer > 1 then
    globalstep_timer = 0
    for _, timer in pairs(ac.timers) do
      timer.time = timer.time + 1
      if timer.func ~= nil
      and timer.time >= timer.trigger then
        timer.trigger = math.random(timer.trigger_min, timer.trigger_max)
        timer.func()
      end
    end
  else
    globalstep_timer = globalstep_timer + dtime
    return
  end
  -- the rest will happen once per sec

  -- don't do anything if it's up to speed
  if ac.wind_speed >= ac.wind_target then return end
  ac.wind_speed = ac.wind_speed + dtime * ac.wind_change_mult
  ac.wind_speed = clamp(ac.wind_speed, 0, ac.wind_target)
  ac.wind = vector.multiply(ac.wind_dir, ac.wind_speed)
end

sum_air_currents.get_wind = function(pos)
  local empty = {x=0, y=0, z=0}
  if not ac.enabled then return empty end
  if not ac.push_entities then return empty end
  local light = ac.get_light(pos)
  if light == 15 then
    return ac.wind
  else return empty end
end
-- apply the wind to an existing velocity
sum_air_currents.apply_wind = function(vel, pos)
  if not ac.enabled then return vel end
  if not ac.push_entities then return vel end
  local light = ac.get_light(pos)
  if light == 15 then
    return vector.add(vel, ac.wind)
  else return vel end
end


minetest.register_globalstep(sum_air_currents.on_step)

