local S = minetest.get_translator(minetest.get_current_modname())

local ac = sum_air_currents

minetest.register_chatcommand("wind", {
	params = "(wind | wind [on/off] | wind [speed] | wind pushplayers [true/false] | wind pushentities [true/false] | wind change)",
	description = S("Changes the wind speed to the specified parameter."),
	privs = {weather_manager = true},
	func = function(name, param)
		local parse1, parse2 = string.match(param, "(%w+) ?(%w+)")
		local wind_speed = tonumber(param)
    if (param == "change") then
      ac.timers.change_dir.time = ac.timers.change_dir.trigger
      return true, S("Wind has changed course.")
		elseif (param == "off") then
			ac.enabled = false
			return true, S("Wind is off.")
		elseif (param == "on") then
			ac.enabled = true
			return true, S("Wind is on.")
    elseif (param == "") then
			return true, S("Wind is " .. ac.wind_speed .. " toward " .. ac.wind_yaw .. ".")
		elseif type(wind_speed) == "number" then
				ac.wind_speed = wind_speed
				ac.wind_target = wind_speed+0.01
				return true, S("Wind is set to " .. wind_speed)
		end
		if parse1 then
      if parse1 == "pushplayers" then
        if parse2 == "true" then
          ac.push_players = true
          return true, S("Wind will push players.")
        elseif parse2 == "false" then
          ac.push_players = false
          return true, S("Wind will not push players.")
        end
      elseif parse1 == "pushentities" then
        if parse2 == "true" then
          ac.push_entities = true
          return true, S("Wind will push entities.")
        elseif parse2 == "false" then
          ac.push_entities = false
          return true, S("Wind will not push entities.")
        end
			end
			return false, S("Error: windspeed " .. wind_speed)
		end
		return false, S("Error: Invalid")
	end
})
