local S = minetest.get_translator(minetest.get_current_modname())

local ac = sum_air_currents

-- gets just the wind speed
sum_air_currents.get_wind_speed = function()
  return ac.wind_speed
end
ac.get_wind_speed_at = function(p)
  if ac.get_light(p) == 15 then
    return ac.wind_speed
  else return 0 end
end
-- gets just the wind direction if not zero
sum_air_currents.get_wind_dir = function()
  if ac.wind_speed ~= 0 then
    return ac.wind_dir
  else
    return vector.new(0,0,0)
  end
end
-- get the wind as a vector
sum_air_currents.get_wind = function(pos)
  if not ac.enabled then return vector.new(0,0,0) end
  local light = ac.get_light(pos)
  if light == 15 then
    return ac.wind
  else return vector.new(0,0,0) end
end
-- apply the wind to an existing velocity
sum_air_currents.apply_wind = function(vel, pos)
  if not ac.enabled then return vel end
  if not ac.do_push_entities then return vel end
  local light = ac.get_light(pos)
  if light == 15 then
    return vector.add(vel, ac.wind)
  else return vel end
end
-- get the light level to determine if you can have wind or not
sum_air_currents.get_light = function(pos)
  local ret = 0
  if minetest.get_natural_light then
    ret = minetest.get_natural_light(pos, 0.5)
  else
    ret = minetest.get_light(pos, 0.5)
    -- so that we can use get_natural_light < 10 eg.
    if ret and ret < 15 then ret = 1 end
  end
  if not ret then ret = 0 end
  return ret
end