local S = minetest.get_translator(minetest.get_current_modname())

sum_air_currents = {
  enabled = true,
  -- constants
  max_wind_speed = 10, -- maxiumum speed of wind unless changed with commands
  wind_change_mult = 1, -- how fast the wind gets up to speed
  stillness_chance = 0.1, -- chance that the wind will decide to stay 0 this time
  player_particles_threshold = 0.3, -- minimum wind speed to spawn wind particles
  -- realtime vars (DONT CHANGE THESE)
  wind_yaw = 3.14, -- affects dir
  wind_dir = vector.new(0,0,0), -- dir of the yaw
  wind_speed = 0, -- wind speed currently (pun unintended)
  wind = vector.new(0,0,0), -- ACTUAL wind, as calculated with wind_dir and wind_speed
  wind_target = 10, -- the speed the wind wants to get to
  -- enables features (setting them here does nothing)
  do_player_particles = false,
  do_push_entities = false,
  do_push_players = false,
}

local ac = sum_air_currents

dofile(minetest.get_modpath("sum_air_currents") .. DIR_DELIM .. "utility_functions.lua")
dofile(minetest.get_modpath("sum_air_currents") .. DIR_DELIM .. "api.lua")
dofile(minetest.get_modpath("sum_air_currents") .. DIR_DELIM .. "sound.lua")
dofile(minetest.get_modpath("sum_air_currents") .. DIR_DELIM .. "particles.lua")
dofile(minetest.get_modpath("sum_air_currents") .. DIR_DELIM .. "commands.lua")

-- load settings
ac.wind_change_mult = tonumber(minetest.settings:get("wind_change_mult") or ac.wind_change_mult)
ac.stillness_chance = tonumber(minetest.settings:get("wind_stillness_chance") or ac.stillness_chance)
ac.do_player_particles = minetest.settings:get_bool("wind_player_particles") ~= false
ac.do_push_players = minetest.settings:get_bool("wind_push_players") ~= false
ac.do_push_entities = minetest.settings:get_bool("wind_push_entities") ~= false
ac.sound_system.gain = tonumber(minetest.settings:get("wind_volume") or 1)

local clamp = function(num, min, max)
  return (math.min(math.max(num, min), max))
end

local globalstep_timer = 1 -- start immediately
ac.timers = {
  change_dir = {time = 0, trigger = 1, func = nil, trigger_min = 120, trigger_max = 300},
}
-- load timer settings
ac.timers.change_dir.trigger_min = tonumber(minetest.settings:get("wind_change_time_min") or ac.timers.change_dir.trigger_min)
ac.timers.change_dir.trigger_max = tonumber(minetest.settings:get("wind_change_time_max") or ac.timers.change_dir.trigger_max)

ac.timers.change_dir.func = function()
  ac.wind_yaw = math.random(0, 100) * math.pi * 2 / 100
  ac.wind_dir = minetest.yaw_to_dir(ac.wind_yaw)
  ac.wind_speed = 0
  if math.random(0, 1) < ac.stillness_chance then
    ac.wind_target = 0
  else
    ac.wind_target = ((math.random(0, (ac.max_wind_speed) ^ 2) * 100) / 100) / ac.max_wind_speed
  end
  ac.wind_change_mult = math.random(0.1, 20)
  ac.timers.change_dir.time = 0
end

sum_air_currents.on_step = function(dtime)
  if not ac.enabled then return end
  -- only do it once a second
  if globalstep_timer > 1 then
    globalstep_timer = 0
    for _, timer in pairs(ac.timers) do
      timer.time = timer.time + 1
      if timer.func ~= nil
      and timer.time >= timer.trigger then
        timer.trigger = math.random(timer.trigger_min, timer.trigger_max)
        timer.func()
      end
    end
  else
    globalstep_timer = globalstep_timer + dtime
    return
  end
  -- the rest will happen once per sec

  -- don't do anything if it's up to speed
  if ac.wind_speed > ac.wind_target then return end
  ac.wind_speed = ac.wind_speed + dtime * ac.wind_change_mult
  ac.wind_speed = clamp(ac.wind_speed, 0, ac.wind_target)
  ac.wind = vector.multiply(ac.wind_dir, ac.wind_speed)
end

minetest.register_globalstep(sum_air_currents.on_step)

