local S = minetest.get_translator(minetest.get_current_modname())

local ac = sum_air_currents

local function get_overall_velocity(vector)
	local v = math.sqrt(vector.x^2 + vector.y^2 + vector.z^2)
	return v
end

local clamp = function(num, min, max)
  return (math.min(math.max(num, min), max))
end

local do_player_particles = function(dtime)
	 if not ac.enabled then return end
  if not ac.do_player_particles then return end
  if not ac.do_push_players and math.random(0, ac.max_wind_speed) < ac.wind_speed then return end

  local players = minetest.get_connected_players()
  for _, player in pairs(players) do
    local v = ac.wind
    local p = player:get_pos()

    local light = ac.get_light(vector.offset(p, 0, 1, 0))
    if light and light < 15 then return end
    if ac.do_push_players == true then
      if player.elytra then
        player:add_velocity(vector.multiply(v, 0.1))
      else
        local vel = {
          x = clamp(v.x, -3, 3),
          y = clamp(v.y, -3, 3),
          z = clamp(v.z, -3, 3),
        }
        player:add_velocity(vector.multiply(vel, 0.1))
      end
    end

    if ac.do_player_particles and get_overall_velocity(v) > ac.player_particles_threshold
    and math.random(0, ac.max_wind_speed) < ac.wind_speed then
      local player_name = player:get_player_name()
      local spread = 0.02
      p = vector.add(p, vector.multiply(v, -1))
      p = vector.offset(p, math.random(-100, 100)*spread, math.random(-100, 100)*spread, math.random(-100, 100)*spread)
      minetest.add_particle({
        pos = p,
        velocity = vector.multiply(v, 2),
        expirationtime = math.random(0.5, 2),
        size = math.random(70, 100)/100,
        collisiondetection = false,
        vertical = false,
        texture = "sum_air_currents_speed_trail.png",
        playername = player_name,
      })
    end
  end
end

minetest.register_globalstep(do_player_particles)
