local S = minetest.get_translator(minetest.get_current_modname())


-- Staticdata handling because objects may want to be reloaded
function sum_parachute.get_staticdata(self)
	local data = {
		_lastpos = self._lastpos,
		_age = self._age,
	}
	return minetest.serialize(data)
end
function sum_parachute.on_activate(self, staticdata, dtime_s)
	local data = minetest.deserialize(staticdata)
	if data then
		self._lastpos = data._lastpos
		self._age = data._age
	end
end


sum_parachute.set_attach = function(self)
  if not self._driver then return end
	self._driver:set_attach(self.object, "",
		{x = 0, y = 0, z = 0}, {x = 0, y = 0, z = 0})
end

sum_parachute.attach_object = function(self, obj)
	self._driver = obj
	sum_parachute.set_attach(self)

	-- local visual_size = get_visual_size(obj)
	local yaw = self.object:get_yaw()
	if obj and obj:is_player() then
		local name = obj:get_player_name()
		if mcl then mcl_player.player_attached[name] = true end
  end
  if self._driver then
    self.object:set_yaw(minetest.dir_to_yaw(self._driver:get_look_dir()))
  end
end

sum_parachute.detach_object = function(self, change_pos)
	self:set_detach()
	-- self:set_properties({visual_size = get_visual_size(self)})
	if self:is_player() and mcl then
		mcl_player.player_attached[self:get_player_name()] = false
		mcl_player.player_set_animation(self, "stand" , 30)
	end
	if change_pos then
		self:set_pos(vector.add(self:get_pos(), vector.new(0, 0, 0)))
	end
end

-- dummy function until added
sum_parachute.on_death = function(self, nothing)
  self.object:set_properties({
    physical = true
  })
  minetest.sound_play("sum_parachute_fold", {
		gain = 1,
    object = self.object,
	})
  local drop = true
  if self._driver and self._driver:is_player() then
    if minetest.is_creative_enabled(self._driver:get_player_name()) then
      drop = false
    end
  end

  if drop then
    minetest.add_item(self.object:get_pos(), "sum_parachute:parachute_bag")
    minetest.add_item(self.object:get_pos(), "sum_parachute:parachute_chute")
  end
	if self._driver then
		sum_parachute.detach_object(self._driver, false)
	end
end

-- sum_parachute

sum_parachute.get_movement = function(self)
  if not self._driver or not self._driver:is_player() then return vector.new() end
  local ctrl = self._driver:get_player_control()
  if not ctrl then return vector.new() end

  local dir = self._driver:get_look_dir()
  dir.y = dir.y / 10
  local forward = 0.5
  if ctrl.up then
    forward = 1
  elseif ctrl.down then
    forward = -0.5
  end
  local v = vector.new()
  v = vector.multiply(dir, forward)
  return v
end

local gravity = -5
local move_speed = 8
sum_parachute.on_step = function(self, dtime)
  if self._age < 100 then self._age = self._age + dtime end
  local p = self.object:get_pos()
  local node_floor = minetest.get_node(vector.offset(p, 0, -0.2, 0))
  local exit = (self._driver and self._driver:get_player_control().sneak)
            or (self._age > 1 and not self._driver)
  if exit or minetest.registered_nodes[node_floor.name].walkable then
    sum_parachute.on_death(self, nil)
    self.object:remove()
    return false
  end

  if self._driver then
    self.object:set_yaw(minetest.dir_to_yaw(self._driver:get_look_dir()))
  end

  local a = vector.new()
  a = vector.multiply(sum_parachute.get_movement(self), move_speed)
  a = vector.add(a, vector.new(0, gravity, 0))
  if sum_air_currents and sum_air_currents.get_wind ~= nil then
    a = vector.add(a, vector.multiply(sum_air_currents.get_wind(p), 2))
  end
  self.object:set_acceleration(a)

  local vel = self.object:get_velocity()
  -- vel = vector.multiply(vel, 0.99)
  vel.x = vel.x * 0.97
  vel.y = vel.y * 0.96
  vel.z = vel.z * 0.97
  self.object:set_velocity(vel)
end

local cbsize = 0.1
local parachute_ENTITY = {
	physical = false,
	timer = 0,
  backface_culling = false,
	visual = "mesh",
	mesh = "sum_parachute.b3d",
	textures = {"sum_parachute_texture.png"},
	visual_size = {x=1, y=1, z=1},
	collisionbox = {-cbsize, -cbsize, -cbsize,
                   cbsize,  cbsize,  cbsize},
	pointable = false,

	get_staticdata = sum_parachute.get_staticdata,
	on_activate = sum_parachute.on_activate,
  on_step = sum_parachute.on_step,
	_thrower = nil,
  _pilot = nil,
  _age = 0,

	_lastpos={},
}

minetest.register_entity("sum_parachute:parachute_ENTITY", parachute_ENTITY)