

# Usage
To get a key from storage:
```lua
world_storage:get_key(domain, key)
```

To save a key to storage:
```lua
world_storage:set_key(domain, key, val, flags)
```


# As a world settings solution
You can also use the chat command to set custom settings that can be used by your mods instead of the global minetest server settings. Note this cannot affect domains other than "world_setting", and this is its intended and only valid use. The first param is n for number or s for string / raw.
```
wset n key 389.2
wset s key some string of letters, even with spaces
wset [anything] key nil -- deletes a key
```
Then, these values can be accessed with the "world_setting" domain:
```lua
local value = world_storage:get_key("world_setting", "my_setting_name")
-- e.g.
local reload_time = world_storage:get_key("world_setting", "pmb_muskets_reload_multiplier")
```
To make sure you don't get nil or have to check for it all the time, you can do this with all of your stored variables:
```lua
if world_storage:get_key("world_setting", "pmb_muskets_reload_multiplier") == nil then
    world_storage:set_key("world_setting", "pmb_muskets_reload_multiplier", "my_default_value")
end
```



# Parameters
## domain
This is the `filename` used for the saving of the data. Each domain is a list - `world_storage.domain[domainname] = {}`.
You can overwrite keys from other mods with this, so choose a unique name, such as the name of your mod.
## key
The key name / variable name you want to save
## val
The arbitrary data you want to save
## flags
Only one flag implemented so far:
- timeout : used to tell the system how long between autosaves



# Notes on usage
The system will autosave regularly if there are changes made, and this is important to note. If you are saving a lot of data, this is not the right system to use. Instead, construct your own system to handle your specific use case. For example, if you need to store several kilobytes of data regularly, **this is not how you do it.**

