# Purpose of this API

This API provides functionality for easily creating and handling events - as well as registering functions to them. With options for automated setup.

The idea of this API is based on the idea behind Roblox's Luau's event functionality. The `event.register` functionality providing a function for disconnecting a registered function from said event.



# API Functions

`events_api.create(name, def)`

name: expected string, name of the event - should NOT include "on"

def: optional table, used for automated setup with provided values

 - `def.funcsgroup`
 - optional table, a table to add a reference to the events' registered functions (`event.funcs`) list to
 - `def.handlers`
 - optional table, a table to add a copy of the events' handler function (`event.handler`) to
 - `def.global`
 - optional table, should be your mod's global table. Adds a `register_on_myevent` (equal to `event.register`) function to your mod's global to register functions for the event

def: or for unique ways of handling your event!

 - `def.after_event`
 - `def.after_event(funcsdata, ...)`
 - optional function, called each time after an event finishes calling its funcs. First parameter is a table (`funcsdata`) of `funcdata` (data = `{returned = {func's returned values}, id = func_index (useful for table.remove(funcs, id) ), func = func (actual function)}`). The `returned` of a `funcdata` will be an array of what the function returns, can have no values (nil), and saves position of any `nil` with null character `\0`. Additional parameters afterwards will be what the function was called with in `event.handler(...)`. If wishing to delete a function, it is HEAVILY recommended to use `funcdata.func` to use for identification purposes in an ipair loop and utilizing `table.remove(data.funcs, index)`, as removing based off of `id` with `data.funcs[id] = nil` can leave holes that cause errors, and if `table.remove` is utilized - will cause a misalignment for future uses of `funcdata.id`
 - `def.prior_to_each_handler_func` (PTEHF)
 - `def.prior_to_each_handler_func(funcdata, ...)`
 - optional function, called prior to each handler function (functions registered to event) being called. First parameter is a table of function information (`{id = (function id in data.funcs), func = (actual function)}`). Parameters after will be what the handler function is called with. EXPECTED TO RETURN THE SAME NUMBER OF PARAMETERS AS THE EVENT. This function should be used if you wish to copy/clone a table for each individual registered function to your event.

Function returns a table of the event's internal structure. See "Event Internal Structure" for more information.


`events_api.is_nil(val)`

val: any value

Function returns `true` or `false` depending on if provided value is equal to null string character or nil (true) or any other value (false)


`events_api.convert_variable_args(...)`

...: tuple of arguments to be converted into an iteratable table, converts any `nil` to `\0` (null string character) as to preserve their positions

Function returns a table array of values that can be re-tuple'd (unpacked) with Lua's `unpack()`



# Event Internal Structure

`events_api.create` will return a table of information:

 - `event.funcs`
 - an array of registered functions to your event that can be added and removed by `event.register
 - `event.handler(...)`
 - a function for running the event's registered functions (`event.funcs`) with provided parameters
 - `...` being whatever values you decided to pass on
 - equal to calling returned table as `event(...)`
 - `event.register(func)`
 - a function for registering functions to the `event.funcs` table. 
 - returns a function for disconnecting the function from the `event.funcs` table, ceasing all calls of the function by the event.