--[[
(C) TPH/tph9677/TubberPupperHusker/TubberPupper/Damotrix
MIT License
https://opensource.org/license/mit

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
--]]

-- pairs
pairs = function(t, k) -- table, key
    if type(t) ~= "table" then
        error("bad argument #1 to 'pairs' (table expected, got "..type(t)..")")
    end
    -- actually call the metamethod
    local met = getmetatable(t) -- probably laggy, but we don't have much choice
    if met and met.__pairs then
        return met.__pairs(t, k)
    end
    -- otherwise default to using next
    return next, t, nil
end

-- ipairs
do
    local iter = function(t, i)
        i = i + 1
        local v = t[i]
        if v==nil then return end
        return i, v
    end
    ipairs = function(t)
        if type(t) ~= "table" then
            error("bad argument #1 to 'ipairs' (table expected, got "..type(t)..")")
        end
        local met = getmetatable(t)
        if met and met.__ipairs then
            return met.__ipairs(t)
        end
        -- otherwise default to using iter function
        return iter, t, 0
    end
end

-- used for invoking the `.__len` argument of metatables
function length(item)
    if type(item) == "table" then
        -- vector
        if vector and vector.check and vector.check(item) then
            return vector.length(item)
        end
        -- regular tables
        local met = getmetatable(item) -- metatable
        if met and met.__len then
            return met.__len(item)
        else
            return #item
        end
    -- strings are cool
    elseif type(item) == "string" then
        return item:len()
    end
    -- no detected length functionality
    error("bad argument #1 to 'length' (provided argument does not have length functionality, got type "..type(item))
end

--testing
--[[
local e = {
    "yeee",
    5,
    28419,
    "purr",
    "galypso"
}
local gb = setmetatable({},{
    __pairs = function(t, k)
        return pairs(e, k)
    end,
    __ipairs = function(t)
        return ipairs(e)
    end,
    __len = function(t)
        return 12591589
    end
})

core.after(0.5, function()
    core.log("starting")
    for gg,vv in pairs(gb) do
        core.log(tostring(gg).." : "..tostring(vv))
    end
    core.log("length "..length(gb))
end)
--]]