--[[
(C) TPH/tph9677/TubberPupperHusker/TubberPupper/Damotrix
MIT License
https://opensource.org/license/mit

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
--]]

-- pairs
pairs = function(t) -- table
    if type(t) ~= "table" then
        error("bad argument #1 to 'pairs' (table expected, got "..type(t)..")")
    end
    -- actually call the metamethod
    local met = getmetatable(t) -- prob laggy
    local mmpairs = type(met) == "table" and rawget(met, "__pairs") -- metamethod pairs
    if mmpairs then
        return mmpairs(t)
    end
    -- otherwise default to using next
    return next, t, nil
end

-- ipairs
do
    local iter = function(t, i)
        i = i + 1
        local v = t[i]
        if v==nil then return end
        return i, v
    end
    ipairs = function(t)
        if type(t) ~= "table" then
            error("bad argument #1 to 'ipairs' (table expected, got "..type(t)..")")
        end
        local met = getmetatable(t)
        local mmipairs = type(met) == "table" and rawget(met, "__ipairs") -- metamethod ipairs
        if mmipairs then
            return mmipairs(t)
        end
        -- otherwise default to using iter function
        return iter, t, 0
    end
end

-- used for invoking the `.__len` argument of metatables
function length(item)
    -- we can quickly do this
    if type(item) == "string" then
        return item:len()
    end
    local met = getmetatable(item) -- metatable
    local mmlen = type(met) == "table" and rawget(met, "__len") -- metamethod len
    if mmlen then
        return mmlen(item)
    elseif type(item) == "table" then
        return #item
    end
    -- no detected length functionality
    error("bad argument #1 to 'length' (provided argument does not have length functionality, got type "..type(item))
end

-- modify `setmetatable` to provide a new callback
do
    local osmt = setmetatable -- old set metatable
    setmetatable = function(tbl, amet) -- table, add metatable
        local met = getmetatable(tbl)
        local mmsmt = type(met) == "table" and rawget(met, "__setmetatable") -- metamethod setmetatable
        if mmsmt then
            local result = mmsmt(tbl, amet)
            -- not allowed to overwrite
            if result == false then return end
            -- hmm, returning a table
            if type(result) == "table" then return result end
        end
        -- no blockage, set that metatable!
        return osmt(tbl, amet)
    end
end

--testing
--[[
local e = {
    "yeee",
    5,
    28419,
    "purr",
    "galypso"
}
local gb = setmetatable({},{
    __pairs = function(t, k)
        return pairs(e, k)
    end,
    __ipairs = function(t)
        return ipairs(e)
    end,
    __len = function(t)
        return 12591589
    end,
    __setmetatable = function(tbl, met)
        core.log("no touchy!")
        return false
    end
})

core.after(0.5, function()
    core.log("starting")
    for gg,vv in pairs(gb) do
        core.log(tostring(gg).." : "..tostring(vv))
    end
    core.log("length "..length(gb))
    setmetatable(gb, {})
    for gg,vv in pairs(gb) do
        core.log(tostring(gg).." : "..tostring(vv))
    end
end)
--]]