tph_doors = tph_doors

local S = minetest.get_translator("doors")

minetest.register_alias_force("doors:hidden","air") -- get rid of unnecessary ghost node

local function door_interact_realistic(pos,...)
  if tph_doors.can_interact_realistic(pos,...) then
    return true
  end
  minetest.sound_play("mt_doors_redo_doorknob_locked",{
    pos = pos,
    gain = 0.2,
    max_hear_distance = 10,
    pitch = math.random(98,110)/100
  })
  return false
end

-- door replacements
tph_doors.register_door("mt_doors_redo:door_wood",{
  description = minetest.registered_nodes["doors:door_wood_a"].description,
  tiles = {{ name = "doors_door_wood.png", backface_culling = true }},
  inventory_image = "doors_item_wood.png",
  groups = {node = 1, choppy = 2, oddly_breakable_by_hand = 2, flammable = 2},
  sounds = default.node_sound_wood_defaults(),
  door_interact = door_interact_realistic
})
tph_doors.hard_conversion("doors:door_wood","mt_doors_redo:door_wood")

tph_doors.register_door("mt_doors_redo:door_steel",{
  description = minetest.registered_nodes["doors:door_steel_a"].description,
  tiles = {{name = "doors_door_steel.png", backface_culling = true}},
  inventory_image = "doors_item_steel.png",
  protected = true,
  groups = {node = 1, cracky = 1, level = 2},
  sounds = default.node_sound_metal_defaults({
    door_close = {name="doors_steel_door_close",gain=0.2},
    door_open = {name="doors_steel_door_open",gain=0.2}
  }),
  door_interact = door_interact_realistic
})
tph_doors.hard_conversion("doors:door_steel","mt_doors_redo:door_steel")

tph_doors.register_door("mt_doors_redo:door_glass",{
  description = minetest.registered_nodes["doors:door_glass_a"].description,
  tiles = {"doors_door_glass.png"},
  inventory_image = "doors_item_glass.png",
  groups = {node = 1, cracky=3, oddly_breakable_by_hand=3},
  sounds = default.node_sound_glass_defaults({
    door_close = {name="doors_glass_door_close",gain=0.3},
    door_open = {name="doors_glass_door_open",gain=0.25}
  }),
  door_interact = tph_doors.can_interact_realistic
})
tph_doors.hard_conversion("doors:door_glass","mt_doors_redo:door_glass")

tph_doors.register_door("mt_doors_redo:door_obsidian_glass",{
  description = minetest.registered_nodes["doors:door_obsidian_glass_a"].description,
  tiles = {"doors_door_obsidian_glass.png"},
  inventory_image = "doors_item_obsidian_glass.png",
  groups = {node = 1, cracky=3},
  sounds = default.node_sound_glass_defaults({
    door_close = {name="doors_glass_door_close",gain=0.3},
    door_open = {name="doors_glass_door_open",gain=0.25}
  }),
  door_interact = door_interact_realistic
})
tph_doors.hard_conversion("doors:door_obsidian_glass","mt_doors_redo:door_obsidian_glass")

if minetest.get_modpath("xpanes") then
  tph_doors.register_door("mt_doors_redo:door_steel_bar",{
    description = minetest.registered_nodes["xpanes:door_steel_bar_a"].description,
    tiles = {{name = "xpanes_door_steel_bar.png", backface_culling = true}},
		inventory_image = "xpanes_item_steel_bar.png",
		protected = true,
		groups = {node = 1, cracky = 1, level = 2},
    sounds = default.node_sound_metal_defaults({
      door_close = {name="xpanes_steel_bar_door_close",gain=0.13},
      door_open = {name="xpanes_steel_bar_door_open",gain=0.15}
    }),
    door_interact = door_interact_realistic
  })
  tph_doors.hard_conversion("xpanes:door_steel_bar","mt_doors_redo:door_steel_bar")
end

-- override
function tph_doors.set_protection(pos, player)
  local meta = minetest.get_meta(pos)
  local name = type(player) == "string" and player or type(player) == "table" or type(player) == "userdata"
  and player.get_player_name and player:get_player_name() or nil
  if not name or name == "" then return false end -- failure
  meta:set_string("owner",name)
  meta:set_string("infotext", minetest.registered_nodes[minetest.get_node(pos).name].description .. "\n" .. S("Owned by @1", name))
  return true -- success
end


