--[[
(C) TPH/tph9677/TubberPupperHusker/TubberPupper/Damotrix
MIT License
https://opensource.org/license/mit

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
--]]

-- for saving info, as all we need is stuff we can get on mod load
local info = {
    OS = "Unknown", -- default in case of error, assume Linux if unknown
    has_backslash = false -- for OS' like Windows, becareful!
}

-- get modpath for detection
local modpath = core.get_modpath("operating_system_detector") -- all we need to do our magic
info.pathstring = modpath

-- split into its constituent parts
local path = modpath:split("/")
-- only windows will have this unique problem (backslashes)
if #path == 1 then
    path = modpath:split("\\")
    -- if it has backslashes, this will be more than 1
    if #path > 1 then
        -- Windows partitions begin with "letter:" e.g. "C:"
        if path[1]:match("%w:") then
            info.OS = "Windows"
        end
        info.has_backslash = true
    -- no path could be grabbed
    else
        path = nil
    end
end
-- table of paths
info.path = path
-- still more searching to be had
if info.OS == "Unknown" then
    -- set up by Android app installation
    if path[1] == "storage" and path[2] == "emulated" and modpath:match("Android") then
        info.OS = path[4] -- lazy lol
    -- Linux (?) - BSD has the same thing unfortunately
    elseif path[1] == "home" then
        info.OS = "Linux"
    -- Mac (Apple)
    elseif path[1] == "Users" then
        info.OS = "MacOS"
    -- iOS (Apple)
    elseif path[1] == "private" and path[2] == "mobile" then
        info.OS = "iOS"
    end
end
-- you know what to do, boys!
if modpath:match("multicraft") then
    info.MultiCraft = true
end
-- we can determine if it's iPad from MultiCraft
if info.OS == "Unknown" and info.MultiCraft then
    info.OS = "iPad" -- could be iOS, but we'll go iPad anyways
end

--core.log(modpath)
--core.log(info.OS)

-- global for use
OS_detector = {
    -- lowercase permits making a "case insensitive" variant where everything is lowercase
    get_OS = function()
        return info.OS
    end,
    get_path_string = function()
        return info.pathstring
    end,
    get_path = function(lowercase)
        if lowercase then
            local pathstring = info.pathstring:lower()
            return info.has_backslash and pathstring:split("\\") or pathstring:split("/")
        end
        return path and table.copy(info.path)
    end,
    -- unique little operating system, aren't ya?
    has_backslash = function()
        return info.has_backslash
    end,
    -- MULTICRAFT! AAAAAAAAAAAAAA
    is_multicraft = function()
        return info.MultiCraft or false
    end
}