## API
Gets an operating system mod pathstring, pathstring to table, and the suspected active operating system. This predicts what OS is currently active judging by the folders/containers detected in the pathstring - this will NOT yield fully accurate results and should not be expected to - as users can modify how their apps and paths are set up - especially with Unix-based systems. Current checks are based off of what I could find on Google about how the operating systems handle their app folders and file paths.

## DISCLAIMER
The API as it currently stands is ONLY effective for the device running or hosting the mods folder. This is not effective at getting the OS information of connected clients - as it is impossible to access their files. This should thusly be handled for singleplayer focuses.

File systems can be modified by their users - and thus results can be inaccurate due to this. OpenBSD will for example be considered Linux due to both sharing the same file system concept.

Certain operating system checks haven't been tested - nor can be tested with a lacking experimental team.

MultiCraft detection has not yet been tested.

## CURRENT VERIFIED
- Windows 8.1 was used to verify the Windows check
- Manjaro was used to verify the Linux check
- Samsung S9 phone was used to verify the Android check

## Other "Supported" Operating System Checks
- MacOS is hypothetically supported with high suspected accuracy
- iOS and iPad are hypothetically supported with low suspected accuracy

## Accessible global functions
Functions that can be used to determine the OS, get pathstrings of the mod, and whether or not the OS uses backslashes.

Prefixed with `OS_detector`. e.g: `OS_detector.get_OS()`

* `get_OS()`
- Returns name of suspected operating system in string

* `get_path_string()`
- Returns pathstring of the `operating_system_detector` mod

* `get_path()`
- args: `boolean lowercase`
- Returns pathstring as a `string:split()` table, removing slashes and isolating the name of each parent directory into each index. Starting from the root to the mod's folder name. `lowercase` if true, converts each name to lowercase

* `has_backslash()`
- Returns `true` or `false` depending on if the select operating system uses backslashes `\` versus regular slashes `/`. Currently to my knowledge - only true of Microsoft operating systems

* `is_multicraft()`
- Returns `true` or `false` depending on if the user is detected as using MultiCraft. Detection for MultiCraft is untested and should not be determined as accurate.