--[[
(C) TPH/tph9677/TubberPupperHusker/TubberPupper/Damotrix
MIT License
https://opensource.org/license/mit

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
--]]

-- mod will NOT work if not 1.12+
if not (tph_eating.features and tph_eating.features.entity_use_itemstring) then
    error("\n\nprogressive_eating_visuals: requires Dynamic Input-Held Eating v1.12+! Please update!\n\nOr download tph_eating directly from Codeberg https://codeberg.org/TPH/tph_eating\n")
end

-- concatenates parameters of provided strings
local function concat_strings(...)
    return table.concat({...})
end

-- automate deleting fields from metadata
-- metdata is the `to_table` result (optional)
local function delete_fields(meta, delfields, metdata)
    metdata = metdata or meta:to_table()
    if not metdata then return end -- couldn't do this properly
    -- convert lone string to table
    delfields = type(delfields) == "table" and delfields or {delfields}
    -- iterate over delfields
    for _,field in ipairs(delfields) do
        -- found! now DESTROY!
        if metdata.fields[field] then
            metdata.fields[field] = nil
        end
    end
    -- save to meta
    meta:from_table(metdata)
end

-- try to get entity from player's eating data
local function get_entity_from_eating_data(data)
    if type(data) ~= "table" then return end
    local ent = data.entity
    if not ent then
        ent = data.obj and data.obj:get_luaentity()
    end
    return ent
end

-- dirty lazy function lol
-- handles setting meta, changing entity's image, and crunch phase
-- returns meta, phase, image
-- should not be made API, used explicitly to lessen lines needed in crunch phase code and ease future modification
-- imgmodif can be nil - otherwise expected function
local function handle_phases(itemstack, meta, currentphase, nextphrase, entity, image, imgmodif)
    -- shouldn't change!
    if nextphrase <= currentphase then return meta, currentphase, image end
    -- we're changing
    meta = meta or itemstack:get_meta()
    -- modify image, now!
    if imgmodif then
        image = imgmodif(image)
    end
    -- modify meta
    meta:set_string("inventory_image", image)
    meta:set_string("wield_image", image)
    -- modify entity
    entity:use_itemstring(itemstack:to_string())
    -- return
    return meta, nextphrase, image
end

-- get needed pev details from data
-- returns crunch phase, itemdef, maxrepeats, and image
local function get_pev_details(data)
    if type(data) ~= "table" then return end
    local itemdef = data.tool_def
    return data.crunch_phase or 0, itemdef, data.eating_info.eating_repeats, data.pev_img or itemdef.inventory_image
end

-- used to reset the item's image if dropped
-- func argument for using item's previous `on_drop` behaviour
local function pev_on_drop_format(func)
    func = type(func) == "function" and func or core.item_drop -- return old behaviour or default
    return function(itemstack, ...) -- itemstack, player, pos
        delete_fields(itemstack:get_meta(), {"inventory_image", "wield_image"})
        return func(itemstack, ...)
    end
end

-- uses `tph_eating_failed` item callback
-- erases modified inventory+wield itemstack images
local function pev_eating_failed(player, itemstack, data, reason)
    -- we shouldn't be doing ANYTHING unless the reason is because the player stopped eating
    -- or if the index was modified
    if reason ~= "stopped" and reason ~= "index changed" then return end
    if not data.index then return end -- can't do anything without an index
    if not data.tool_def then return end -- can't do anything without a tool definition
    -- used to modify player's inventory directly
    -- this is because `tph_eating_failed` does not permit modifying the itemstack directly
    local pinv = player:get_inventory()
    if not pinv then return end -- huh, no inventory?
    local stackat = pinv:get_stack("main", data.index) -- figure out if we're the same thing at this index
    if stackat:get_name() ~= data.tool_def.name then return end -- conflicts with `on_drop` if not checked for
    delete_fields(itemstack:get_meta(), {"inventory_image", "wield_image"})
    -- set stack to player's main to avoid accidentally overriding another item if slot was changed
    pinv:set_stack("main", data.index, itemstack)
end

-- uses `tph_eating_on_leaveplayer` item callback
-- erases modified inventory+wield itemstack images
local function pev_on_leaveplayer(player, itemstack, data)
    delete_fields(itemstack:get_meta(), {"inventory_image", "wield_image"})
    return itemstack
end

-- for MTG's red and brown mushrooms
-- 1.12+ `tph_eating` item callback `tph_eating_on_iteration`
local function pev_mushroom_iteration(plr, itemstack, data, iter)
    local ent = get_entity_from_eating_data(data)
    if not ent then return end -- no entity to use!
    -- crunch phase, item definition, eating repeats,
    -- image (data's `pev_img` (progressive eating visuals image) or itemdef's `inventory_image` to create)
    local cphase, itemdef, maxrepeats, img = get_pev_details(data)
    local meta -- do not call `get_meta` unnecessarily, permit usage if two checks or more happen at the same time
    local perc = iter/maxrepeats -- percentage consumed
    -- only modify image if crunch phase hasn't been modified accordingly
    if perc <= 0.33 then
        -- itemstack, meta, current crunch phase, next anticipated crunch phase, entity, image,
        -- image modification function
        meta, cphase, img = handle_phases(itemstack, meta, cphase, 1, ent, img,
        function()
            return img.."^"..(math.random() < 0.5 and "[mask:(pev_mushroom_mask_left.png^[transformFX)"
              or "[mask:pev_mushroom_mask_left.png")
        end)
    elseif perc <= 0.66 then
        meta, cphase, img = handle_phases(itemstack, meta, cphase, 2, ent, img,
        function()
            return img..(img:match("transformFX") and "^[mask:pev_mushroom_mask_left.png"
              or "^[mask:(pev_mushroom_mask_left.png^[transformFX])")
        end)
    else
        meta, cphase, img = handle_phases(itemstack, meta, cphase, 3, ent, img,
        function()
            return itemdef.inventory_image.."^[mask:pev_mushroom_mask_middle.png"
        end)
    end
    -- finished eating
    if iter >= data.eating_info.eating_repeats then
        -- ideally use stored meta argument, otherwise get fresh meta
        delete_fields( (meta or itemstack:get_meta() ), {"inventory_image", "wield_image"})
        -- erase crunch phase and image from data
        cphase = nil
        img = nil
    end
    -- update
    data.crunch_phase = cphase
    data.pev_img = img
    return itemstack
end

-- chance to pick bottom or either of the sides
local function jelys_pineapple_lottery(data, img, isend)
    local jpfb = data.pev_jpfb -- jelys_pineapple_first_bite
    -- one of the sides was done, eat bottom
    if jpfb == "sides" then
        data.pev_jpfb = "complete"
        img = img.."^[mask:pev_pizzaria_pineapple_bottom_mask.png"
    -- bottom was eaten first, eat one of the sides
    elseif jpfb == "bottom" then
        data.jpfb = "complete"
        img = concat_strings(img, "^[mask:pev_pizzaria_pineapple_", (math.random() > 0.5 and "right" or
          "left"), "_mask.png")
    -- finish 'em off
    elseif jpfb == "complete" then
        -- one of the sides will be left, figure out which one
        img = concat_strings(img, "^[mask:pev_pizzaria_pineapple_", (img:match("_left_mask") and "right" or
          "left"), "_mask.png")
    -- who will be our lucky winner!?
    else
        local lottery = {"left", "right", "bottom"} -- we'll become one of these
        local ind = math.random(1, #lottery) -- index, choose 1 to length
        lottery = lottery[ind] -- one has been picked!
        img = concat_strings(img, "^[mask:pev_pizzaria_pineapple_", lottery, "_mask.png")
        -- eating bottom first, or any of the sides first
        data.pev_jpfb = ind == 3 and "bottom" or "sides"
    end
    -- do "complete" mask
    if isend then
        img = img.."^[mask:pev_pizzaria_pineapple_complete_mask.png"
    end
    -- return changes or default
    return img
end

-- supported foods will be listed here
-- item overrides
local items = {
    -- Minetest Game
    ["default:apple"] = {
        -- tph_eating 1.12+ function
        tph_eating_on_iteration = function(plr, itemstack, data, iter)
            local ent = get_entity_from_eating_data(data)
            if not ent then return end -- no entity to use!
            -- crunch phase, item definition, eating repeats,
            -- image (data's `pev_img` (progressive eating visuals image) or itemdef's `inventory_image` to create)
            local cphase, itemdef, maxrepeats, img = get_pev_details(data)
            local meta -- do not call `get_meta` unnecessarily, permit usage if two checks or more happen at the same time
            local perc = iter/maxrepeats -- percentage consumed
            -- only modify image if crunch phase hasn't been modified accordingly
            if perc <= 0.33 then
                -- itemstack, meta, current crunch phase, next anticipated crunch phase, entity, image,
                -- image modification function
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 1, ent, img,
                function()
                    return img.."^"..(math.random() < 0.5 and "[mask:(pev_apple_mask_left.png^[transformFX)"
                      or "[mask:pev_apple_mask_left.png")
                end)
            elseif perc <= 0.66 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 2, ent, img,
                function()
                    return img..(img:match("transformFX") and "^[mask:pev_apple_mask_left.png"
                      or "^[mask:(pev_apple_mask_left.png^[transformFX])")
                end)
            else
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 3, ent, img,
                function()
                    return img.."^pev_apple_core.png"
                end)
            end
            -- finished eating
            if iter >= data.eating_info.eating_repeats then
                -- ideally use stored meta argument, otherwise get fresh meta
                delete_fields( (meta or itemstack:get_meta() ), {"inventory_image", "wield_image"})
                -- erase crunch phase and image from data
                cphase = nil
                img = nil
            end
            -- update
            data.crunch_phase = cphase
            data.pev_img = img
            return itemstack
        end
    },
    ["farming:bread"] = {
        -- tph_eating 1.12+ function
        tph_eating_on_iteration = function(plr, itemstack, data, iter)
            local ent = get_entity_from_eating_data(data)
            if not ent then return end -- no entity to use!
            -- crunch phase, item definition, eating repeats,
            -- image (data's `pev_img` (progressive eating visuals image) or itemdef's `inventory_image` to create)
            local cphase, itemdef, maxrepeats, img = get_pev_details(data)
            local meta -- do not call `get_meta` unnecessarily, permit usage if two checks or more happen at the same time
            local perc = iter/maxrepeats -- percentage consumed
            -- only modify image if crunch phase hasn't been modified accordingly
            if perc <= 0.33 then
                -- itemstack, meta, current crunch phase, next anticipated crunch phase, entity, image,
                -- image modification function
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 1, ent, img,
                function()
                    return img.."^[mask:pev_farming_bread_mask_top.png"
                end)
            elseif perc <= 0.66 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 2, ent, img,
                function()
                    return img.."^"..(math.random() < 0.5 and
                      "[mask:(pev_farming_bread_mask_left.png^[transformFX)" or "[mask:pev_farming_bread_mask_left.png")
                end)
            else
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 3, ent, img,
                function()
                    return img..(img:match("transformFX") and "^[mask:pev_farming_bread_mask_left.png"
                      or "^[mask:(pev_farming_bread_mask_left.png^[transformFX])")
                end)
            end
            -- finished eating
            if iter >= data.eating_info.eating_repeats then
                -- ideally use stored meta argument, otherwise get fresh meta
                delete_fields( (meta or itemstack:get_meta() ), {"inventory_image", "wield_image"})
                -- erase crunch phase and image from data
                cphase = nil
                img = nil
            end
            -- update
            data.crunch_phase = cphase
            data.pev_img = img
            return itemstack
        end
    },
    ["default:blueberries"] = {
        -- tph_eating 1.12+ function
        tph_eating_on_iteration = function(plr, itemstack, data, iter)
            local ent = get_entity_from_eating_data(data)
            if not ent then return end -- no entity to use!
            -- crunch phase, item definition, eating repeats,
            -- image (data's `pev_img` (progressive eating visuals image) or itemdef's `inventory_image` to create)
            local cphase, itemdef, maxrepeats, img = get_pev_details(data)
            local meta -- do not call `get_meta` unnecessarily, permit usage if two checks or more happen at the same time
            local perc = iter/maxrepeats -- percentage consumed
            -- only modify image if crunch phase hasn't been modified accordingly
            if perc <= 0.25 then
                -- itemstack, meta, current crunch phase, next anticipated crunch phase, entity, image,
                -- image modification function
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 1, ent, img,
                function()
                    return img.."^[mask:pev_default_blueberries_mask.png"
                end)
            elseif perc <= 0.5 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 2, ent, img,
                function()
                    return img.."^[mask:pev_default_blueberries_mask2.png"
                end)
            elseif perc <= 0.75 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 3, ent, img,
                function()
                    return img.."^[mask:pev_default_blueberries_mask3.png"
                end)
            else
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 4, ent, img,
                function()
                    return img.."^[mask:pev_default_blueberries_mask4.png"
                end)
            end
            -- finished eating
            if iter >= data.eating_info.eating_repeats then
                -- ideally use stored meta argument, otherwise get fresh meta
                delete_fields( (meta or itemstack:get_meta() ), {"inventory_image", "wield_image"})
                -- erase crunch phase and image from data
                cphase = nil
                img = nil
            end
            -- update
            data.crunch_phase = cphase
            data.pev_img = img
            return itemstack
        end
    },
    ["flowers:mushroom_brown"] = {tph_eating_on_iteration = pev_mushroom_iteration},
    ["flowers:mushroom_red"] = {tph_eating_on_iteration = pev_mushroom_iteration},
    -- jelys' pizzaria
    ["jelys_pizzaria:pineapple"] = {
        tph_eating_repeats = 5, -- take a little bit longer
        -- tph_eating 1.12+ function
        tph_eating_on_iteration = function(plr, itemstack, data, iter)
            local ent = get_entity_from_eating_data(data)
            if not ent then return end -- no entity to use!
            -- crunch phase, item definition, eating repeats,
            -- image (data's `pev_img` (progressive eating visuals image) or itemdef's `inventory_image` to create)
            local cphase, itemdef, maxrepeats, img = get_pev_details(data)
            local meta -- do not call `get_meta` unnecessarily, permit usage if two checks or more happen at the same time
            local perc = iter/maxrepeats -- percentage consumed
            -- only modify image if crunch phase hasn't been modified accordingly
            if perc <= 0.25 then
                -- itemstack, meta, current crunch phase, next anticipated crunch phase, entity, image,
                -- image modification function
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 1, ent, img,
                function(image)
                    return jelys_pineapple_lottery(data, image)
                end)
            elseif perc <= 0.5 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 2, ent, img,
                function(image)
                    return jelys_pineapple_lottery(data, image)
                end)
            elseif perc <= 0.75 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 3, ent, img,
                function(image)
                    return jelys_pineapple_lottery(data, image)
                end)
            else
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 4, ent, img,
                function(image)
                    return jelys_pineapple_lottery(data, image, true)
                end)
            end
            -- finished eating
            if perc >= 1 then
                -- ideally use stored meta argument, otherwise get fresh meta
                delete_fields( (meta or itemstack:get_meta() ), {"inventory_image", "wield_image"})
                -- erase crunch phase and image from data
                cphase = nil
                img = nil
                data.pev_jpfb = nil -- found in jelys_pineapple_lottery function
            end
            -- update
            data.crunch_phase = cphase
            data.pev_img = img
            return itemstack
        end
    }
}

local function change_itemdef(itemdef)
    if type(itemdef) ~= "table" then return end -- how!
    local invimg = itemdef.inventory_image
    if type(invimg) ~= "string" or invimg == "" then return end -- no inventory image
    local mo = itemdef.mod_origin
    local override = items[itemdef.name]
    -- pizza slice override (https://content.luanti.org/packages/Extex/jelys_pizzaria/)
    if mo == "jelys_pizzaria" and itemdef.name:match("pizza_slice") then
        -- get mask properly
        local function pizzaria_image(img, cphase)
            if cphase == 0 or cphase == 1 then return img end
            return concat_strings(img,"^[mask:pev_pizzaria_slice_mask",cphase,".png")
        end
        -- override table
        override = {
        tph_eating_on_iteration = function(plr, itemstack, data, iter)
            local ent = get_entity_from_eating_data(data)
            if not ent then return end -- no entity to use!
            -- crunch phase, item definition, eating repeats,
            local cphase, itemdef, maxrepeats = get_pev_details(data)
            -- we refresh our img each time
            local img = itemdef.inventory_image
            local meta -- do not call `get_meta` unnecessarily, permit usage if two checks or more happen at the same time
            local perc = iter/maxrepeats -- percentage consumed
            -- only modify image if crunch phase hasn't been modified accordingly
            if perc <= 0.125 then
                -- itemstack, meta, current crunch phase, next anticipated crunch phase, entity, image,
                -- image modification function
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 1, ent, img,
                function()
                    return img.."^[mask:pev_pizzaria_slice_mask.png"
                end)
            elseif perc <= 0.25 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 2, ent, img,
                function()
                    return pizzaria_image(img, 2)
                end)
            elseif perc <= 0.375 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 3, ent, img,
                function()
                    return pizzaria_image(img, 3)
                end)
            elseif perc <= 0.5 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 4, ent, img,
                function()
                    return pizzaria_image(img, 4)
                end)
            elseif perc <= 0.625 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 5, ent, img,
                function()
                    return pizzaria_image(img, 5)
                end)
            elseif perc <= 0.75 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 6, ent, img,
                function()
                    return pizzaria_image(img, 6)
                end)
            else
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 7, ent, img,
                function()
                    return pizzaria_image(img, 7)
                end)
            end
            -- finished eating
            if iter >= data.eating_info.eating_repeats then
                -- ideally use stored meta argument, otherwise get fresh meta
                delete_fields( (meta or itemstack:get_meta() ), {"inventory_image", "wield_image"})
                -- erase crunch phase and image from data
                cphase = nil
                img = nil
            end
            -- update
            data.crunch_phase = cphase
            data.pev_img = img
            return itemstack
        end,
        --tph_eating_repeats = 8
        }
    -- sausage override (https://content.luanti.org/packages/Emojiminetest/sausages/)
    elseif mo == "sausages" then
        override = {
        tph_eating_on_iteration = function(plr, itemstack, data, iter)
            local ent = get_entity_from_eating_data(data)
            if not ent then return end -- no entity to use!
            -- crunch phase, item definition, eating repeats,
            -- image (data's `pev_img` (progressive eating visuals image) or itemdef's `inventory_image` to create)
            local cphase, itemdef, maxrepeats, img = get_pev_details(data)
            -- reverse order, eat from bottom instead of up, can be 1 (normal) or 2 (reverse)
            local revord = data.pev_reverse_order or math.random(2)
            local meta -- do not call `get_meta` unnecessarily, permit usage if two checks or more happen at the same time
            local perc = iter/maxrepeats -- percentage consumed
            -- only modify image if crunch phase hasn't been modified accordingly
            if perc <= 0.25 then
                -- itemstack, meta, current crunch phase, next anticipated crunch phase, entity, image,
                -- image modification function
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 1, ent, img,
                function()
                    return concat_strings(img, "^[mask:pev_sausage_mask", (revord==2 and "4" or
                      ""), ".png")
                end)
            elseif perc <= 0.5 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 2, ent, img,
                function()
                    return concat_strings(img, "^[mask:pev_sausage_mask", (revord==2 and "3" or
                      "2"), ".png")
                end)
            elseif perc <= 0.75 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 3, ent, img,
                function()
                    return concat_strings(img, "^[mask:pev_sausage_mask", (revord==2 and "2" or
                      "3"), ".png")
                end)
            else
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 4, ent, img,
                function()
                    return concat_strings(img, "^[mask:pev_sausage_mask", (revord==2 and "" or
                      "4"), ".png")
                end)
            end
            -- finished eating
            if iter >= data.eating_info.eating_repeats then
                -- ideally use stored meta argument, otherwise get fresh meta
                delete_fields( (meta or itemstack:get_meta() ), {"inventory_image", "wield_image"})
                -- erase crunch phase, image, and reverse_order from data
                cphase = nil
                img = nil
                revord = nil
            end
            -- update
            data.crunch_phase = cphase
            data.pev_img = img
            data.pev_reverse_order = revord
            return itemstack
        end
        }
    -- https://content.luanti.org/packages/jwmhjwmh/large_slugs/
    elseif mo == "large_slugs" and itemdef.name:sub(13,18) == "cooked" then
        -- override table
        override = {
        tph_eating_on_iteration = function(plr, itemstack, data, iter)
            local ent = get_entity_from_eating_data(data)
            if not ent then return end -- no entity to use!
            -- crunch phase, item definition, eating repeats,
            -- image (data's `pev_img` (progressive eating visuals image) or itemdef's `inventory_image` to create)
            local cphase, itemdef, maxrepeats, img = get_pev_details(data)
            local meta -- do not call `get_meta` unnecessarily, permit usage if two checks or more happen at the same time
            local perc = iter/maxrepeats -- percentage consumed
            -- only modify image if crunch phase hasn't been modified accordingly
            if perc <= 0.33 then
                -- itemstack, meta, current crunch phase, next anticipated crunch phase, entity, image,
                -- image modification function
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 1, ent, img,
                function()
                    return concat_strings(img, "^[mask:pev_largeslugs_", (math.random() < 0.5 and "top" or "bottom"),
                      "_mask.png")
                end)
            elseif perc <= 0.66 then
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 2, ent, img,
                function()
                    return img.."^[mask:pev_largeslugs_middle_mask.png"
                end)
            else
                meta, cphase, img = handle_phases(itemstack, meta, cphase, 3, ent, img,
                function()
                    return concat_strings(img, "^[mask:pev_largeslugs_", (img:match("_bottom_mask") and "top" or
                      "bottom"), "_mask.png")
                end)
            end
            -- finished eating
            if iter >= data.eating_info.eating_repeats then
                -- ideally use stored meta argument, otherwise get fresh meta
                delete_fields( (meta or itemstack:get_meta() ), {"inventory_image", "wield_image"})
                -- erase crunch phase and image from data
                cphase = nil
                img = nil
            end
            -- update
            data.crunch_phase = cphase
            data.pev_img = img
            return itemstack
        end
        }
    end
    if not override then return end -- no override!
    -- basics
    override.on_drop = pev_on_drop_format(itemdef.on_drop) -- permit saving the old `on_drop` behaviour if exists
    override.tph_eating_failed = pev_eating_failed -- erase inventory and wield image
    override.tph_eating_on_leaveplayer = pev_on_leaveplayer -- same as `tph_eating_failed` basically
    -- override!
    core.override_item(itemdef.name, override)
end

-- if compatible with `tph_eating`, it will provide the item definition in this registration function
tph_eating.register_on_compatibility_set(function(itemdef, is_drink, automated)
    change_itemdef(itemdef)
end)