--[[
(C) TPH/tph9677/TubberPupperHusker/TubberPupper/Damotrix
MIT License
https://opensource.org/license/mit

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
--]]

tph_adaptive_crosshair = {
    colours = {
        incorrect = "#db1313",
        correct = "#51e411"
    }
}
local tphac = tph_adaptive_crosshair -- shorten

-- "hud_elem_type" is deprecated as of 5.9.0+
local hud_type = core.has_feature("hud_def_type_field") and "type" or "hud_elem_type"

local pstored = {} -- players stored (player data)

-- add data
tph_wielditem.register_on_joinplayer(function(player, pdata)
    local data = {name = pdata.name, player = player}
    pstored[pdata.name] = data
    player:hud_set_flags({crosshair = false}) -- remove CROSSHAIR
    -- create hud
    local newhud = {
        [hud_type] = "image",
        position = { x = 0.5, y = 0.5 },
        --name = "tph_adaptive_crosshair_main",
        scale = { x = 2.5, y = 2.5 },
        number = "0xFFFFFF",
        z_index = 0,
        --text = "tph_adaptive_crosshair_type_regular.png",
    }
    data.hud = {id=player:hud_add(newhud), text=nil, def=newhud}
end)

-- remove data
tph_wielditem.register_on_leaveplayer(function(player, pdata)
    pstored[pdata.name] = nil
end)

--- @param sdata table
--- @param main string
--- @param pointable string
--- @param mouse table
--- @param toolcorrect boolean/nil
local function update_hud(sdata, main, pointable, mouse, toolcorrect)
    local player, name = sdata.player, sdata.name -- helpful
    -- base textures
    main = main or "tph_adaptive_crosshair_type_regular.png"
    pointable = pointable or "tph_adaptive_crosshair_pointable_null.png"
    -- combine base textures
    main = main.."^"..pointable
    -- update hud
    local hud = sdata.hud
    -- only modify main hud if not the same
    if hud.text ~= main then
        player:hud_change(hud.id, "text", main)
        hud.text = main -- update
    end
    -- do toolcorrect stuff
    local hudtc = sdata.hudtc
    if toolcorrect ~= nil then
        if not hudtc then
            -- create new hud
            hudtc = player:hud_add({
                [hud_type] = "image",
                position = { x = 0.5, y = 0.43 },
                --name = "tph_adaptive_crosshair_toolcorrect",
                scale = { x = 1.5, y = 1.5 },
                z_index = 0
            })
            -- update!
            hudtc = {id=hudtc, correct=nil} -- correct will get set by next block
            sdata.hudtc = hudtc
        end
        -- update texture if doesn't equal last saved toolcorrect boolean
        if sdata.hudtc.correct ~= toolcorrect then
            player:hud_change(hudtc.id, "text", table.concat({
                -- beginning of texture name
                "tph_adaptive_crosshair_attribute_",
                -- getting check or cross texture
                (toolcorrect and "check" or "x"), ".png",
                -- colouring
                "^[colorize:", (toolcorrect and tphac.colours.correct or tphac.colours.incorrect)
            }))
            -- update!
            hudtc.correct = toolcorrect
        end
    -- remove hud toolcorrect if nil
    elseif hudtc then
        player:hud_remove(hudtc.id)
        sdata.hudtc = nil
    end
end

-- only if tph_eating is not enabled
if not core.get_modpath("tph_eating") then
    -- iterate through each item after mods load
    -- adding `tphac_edible` group for each "edible" item
    core.register_on_mods_loaded(function()
        for name, def in pairs(core.registered_items) do
            -- can be eaten with on_use!
            if core.serialize(def.on_use):match("item_eat") then
                -- get or create groups
                local groups = def.groups or {}
                -- only override if needed
                if not (groups.edible or groups.eatable) then
                    groups.tphac_edible = 1 -- edible!
                    core.override_item(name, {
                        groups = groups
                    })
                end
            end
        end
    end)
end

-- runs each wielditem step
-- main thread that handles getting item range and definition
-- as well as getting the pointed node or object
tph_wielditem.register_on_step(function(player, itemstack, index, dtime, def, pdata)
    -- grab our own data
    local sdata = pstored[pdata.name] -- stored data
    -- let's fix some things
    if not sdata then
        pdata.name = player:get_player_name()
        sdata = pstored[pdata.name]
    end
    if not sdata then return end -- huh?!
    -- groups of wielded item -- ensure it's at least a table
    local wgroups = def.groups or {}
    -- ensure some form of absolute value
    local range = tonumber(def.range) or core.registered_items[""].range or 5
    -- check what's infront of us!
    -- calculcate!
    -- stole calculations from The Gorge's popup message
    local pos = player:get_pos()
    local eyeheight = player:get_properties().eye_height
    pos.y = pos.y + eyeheight
    local lookdir = player:get_look_dir()
    local lookpos = pos:add(lookdir) -- from our head, looking
    local lookatpos = lookdir:multiply(range - 1):add(lookpos)
    -- raycast! objects, liquids
    local pointed = core.raycast(pos, lookatpos, true, def.liquids_pointable) -- pointed thing
    -- iterate through raycast to ignore player
    for thing in pointed do
        if thing and thing.type then -- valid pointed_thing
            -- avoid us!
            if thing.type == "object" and thing.ref ~= player or thing.type == "node" then
                -- select and break loop upon getting what we want
                pointed = thing
                break
            end
        end
    end
    -- ensure not nil
    pointed = pointed or {}
    -- additional info
    local info = {}
    -- figure out node if node
    if pointed.type == "node" then
        -- previous node!
        local pnode = sdata.prevnode
        if pnode then
            -- if over 1.5sec, we must start fresh!
            if pnode.check < 1.5 then
                -- still equal
                if vector.equals(pnode.pos, pointed.under) then
                    -- simply reuse instead of grabbing anew!
                    info.node = pnode.node
                    info.def = pnode.def
                end
                sdata.prevnode.check = sdata.prevnode.check + dtime
            end
        end
        -- start anew
        if not info.node then
            info.node = core.get_node(pointed.under)
            info.def = core.registered_nodes[info.node.name] or {}
            -- save to prevnode
            sdata.prevnode = {
                check = 0,
                pos = pointed.under,
                node = info.node,
                def = info.def
            }
        end
    -- figure out entity if entity
    elseif pointed.type == "object" then
        -- previous object!
        local pobj = sdata.prevobj
        if pobj then
            -- if it's the same object
            if pobj.obj == pointed.ref then
                info.fulfilled = true -- we're able to find a match!
                -- get info loaded
                info.ent = pobj.ent
                info.is_player = pobj.is_player
            end
        end
        -- information not filled, so start anew!
        if not info.fulfilled then
            info.is_player = core.is_player(pointed.ref)
            if not info.is_player then
                info.ent = pointed.ref:get_luaentity()
            end
            -- save to sdata
            sdata.prevobj = {
                obj = pointed.ref,
                is_player = info.is_player,
                ent = info.ent
            }
        end
    end
    -- remove old information
    if pointed.type ~= "node" then
        sdata.prevnode = nil
    end
    if pointed.type ~= "object" then
        sdata.prevobj = nil
    end
    -- main texture
    -- anything edible has the priority
    local texturemain = (wgroups.tphac_edible or wgroups.edible or wgroups.eatable or wgroups.tph_eating_edible) and
      "tph_adaptive_crosshair_type_edible.png" or
      -- tools!
      def.type == "tool" and (
      -- bows/guns
      (wgroups.bow or wgroups.crossbow or wgroups.ranged_weapon or wgroups.gun) and
      "tph_adaptive_crosshair_type_weaponranged.png" or
      -- swords/weapons!
      (wgroups.sword or wgroups.weapon) and "tph_adaptive_crosshair_type_weapon.png" or
      -- no unique groups generic tool
      "tph_adaptive_crosshair_type_tool.png")
      -- non-tools
      or nil
    -- create pointable texture
    local pointable = pointed.type == "node" and (
        -- group specific
        info.def.groups and (
          info.def.groups.falling_node and "tph_adaptive_crosshair_pointable_nodefalling.png"
        ) or
        -- liquids
        (info.def.drawtype == "flowingliquid" or info.def.drawtype == "liquid") and
        "tph_adaptive_crosshair_pointable_liquid.png" or
        -- formspec inventory stuff
        (info.def.on_metadata_inventory_put or info.def.on_metadata_inventory_take or
          info.def.on_metadata_inventory_move) and
        "tph_adaptive_crosshair_pointable_formspec.png" or
        -- default
        "tph_adaptive_crosshair_pointable_node.png"
    -- objects!
    ) or
    pointed.type == "object" and "tph_adaptive_crosshair_pointable_entity.png"
    -- additional
    if pointed.type == "object" then
        -- add player to entity pointable texture
        if info.is_player then
            pointable = pointable.."^tph_adaptive_crosshair_pointable_player.png"
        -- more entity information!
        elseif info.ent then
            local ent = info.ent
            -- dropped item
            if ent.name == "__builtin:item" then
                pointable = "tph_adaptive_crosshair_pointable_droppeditem.png"
            -- tamed this fellow!
            elseif ent.owner == sdata.name then
                pointable = "tph_adaptive_crosshair_pointable_entitytamed.png"
            end
        end
    end
    -- toolcorrect calculations, commence! (if not already added to info and pointing at node)
    -- toolcorrect_cachenodetool used to determine whether or not to run group caps calculations again
    local tc_cnodetool = sdata.tc_cachenodetool or {} -- same node and tool as previous iteration
    if info.def and info.def.groups then
        local groups = info.def.groups -- node groups
        -- let's run this by again!
        if tc_cnodetool.node ~= info.def.name or tc_cnodetool.tool ~= def.name then
            -- store name strings
            tc_cnodetool = {node=info.def.name, tool = def.name}
            sdata.tc_cachenodetool = tc_cnodetool -- update
            -- calculations actually commence!
            local toolcaps = def.tool_capabilities -- get tool capabilities
            local gc = toolcaps and toolcaps.groupcaps -- group capabilities
            -- calculations!
            if gc then
                sdata.toolcorrect = false -- start false
                -- iterate through groupcaps
                for grp,_ in pairs(gc) do
                    -- we're perfect! break loop
                    if groups[grp] and groups[grp] > 0 then
                        sdata.toolcorrect = true
                        break
                    end
                end
            -- reset cached toolcorrect
            elseif sdata.toolcorrect ~= nil then
                sdata.toolcorrect = nil
            end
        end
    -- reset cached toolcorrect
    elseif sdata.toolcorrect ~= nil then
        sdata.toolcorrect = nil
        -- reset this too else looking at a node without groups makes it a bit awkward
        sdata.tc_cachenodetool = nil
    end
    -- hud texture
    update_hud(sdata, texturemain, pointable, nil, sdata.toolcorrect)
end)