--[[
    Minecraft-like Eating Mod for Exile
    Copyright (C) 2024 TPH/TubberPupperHusker <damotrixrob@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
--]]

-- MOD SUPPORT FOR EXILE
if not minetest.get_modpath("health") or not minetest.get_modpath("minimal") then
  return
end
minetest.register_on_mods_loaded(function()
  -- SETTINGS -------------------------------
  tph_eating.use_function = "_on_use_item"
  tph_eating.use_key = "aux1"
  tph_eating.burping = false
  -------------------------------------------
  local look_through = minimal.merge_tables(food_table,bake_table)
  for name,_ in pairs(look_through) do
    if minetest.get_item_group(name,'edible') > 0 then
      minetest.override_item(name,{
        _eating_success = function(player, itemstack)
          return exile_eatdrink(itemstack, player)
        end,
      })
      tph_eating.add_eating_hook(name,true)
    end
  end
  -- herbal medicine
  local hbm = minetest.registered_items["tech:herbal_medicine"]
  minetest.override_item(hbm.name,{
    _eating_success = function(player, itemstack)
      return hbm._on_use_item(player, itemstack)
    end
  })
  tph_eating.add_eating_hook(hbm,true)
  -- tiku
  local tiku = minetest.registered_items["tech:tiku"]
  minetest.override_item(tiku.name,{
    _eating_success = function(player, itemstack)
      return tiku._on_use_item(player, itemstack)
    end
  })
  tph_eating.add_eating_hook(tiku,true)
  -- soup
  local soup = minetest.registered_items["tech:soup"]
  minetest.override_item(soup.name,{
    _eating_success = function(player, itemstack)
      return exile_eatdrink_playermade(itemstack, player)
    end
  })
  tph_eating.add_eating_hook(soup,true)
end)