--[[
    Minecraft-like Eating Mod for Exile
    Copyright (C) 2024 TPH/TubberPupperHusker <damotrixrob@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
--]]

-- MOD SUPPORT FOR EXILE
if not minetest.get_modpath("health") or not minetest.get_modpath("minimal") then
  return
end
-- v3 does not have minimal.merge_tables
-- NOT OWNED OR COPYRIGHT BY TPH
local function merge_tables(t1,t2)
  if minimal and minimal.merge_tables then
    return minimal.merge_tables(t1,t2)
  end
  local new_table = table.copy(t1)
  --merge tables
  for key, value in pairs(t2) do
      new_table[key] = value
  end
  return new_table
end
-----------------------------------
minetest.register_on_mods_loaded(function()
  local is_v4 = minetest.get_modpath("mapchunk_shepherd") and true or false
  -- only v4 has the mapchunk shepherd
  if is_v4 then
    -- v4 SETTINGS -------------------------------
    tph_eating.use_function = "_on_use_item"
    tph_eating.use_key = "aux1"
    -------------------------------------------
  end
  tph_eating.burping = false
  local look_through = merge_tables(food_table,bake_table)
  for name,_ in pairs(look_through) do
    if minetest.registered_items[name] or minetest.registered_craftitems[name] or
    minetest.registered_tools[name] or minetest.registered_nodes[name] then
      if minetest.get_item_group(name,'edible') > 0 and is_v4 then
        tph_eating.add_eating_hook(name,true,
        function(player, itemstack)
          return exile_eatdrink(itemstack, player)
        end)
      else -- v3
        minetest.override_item(name,{
          on_use = function() return end,
          _eating_success = function(player, itemstack)
            return exile_eatdrink(itemstack, player, {type="object",ref=player})
          end,
        })
        tph_eating.add_eating_hook(name)
      end
    end
  end
  -- other edibles
  if is_v4 then
    -- herbal medicine
    local hbm = minetest.registered_items["tech:herbal_medicine"]
    local hbm_old = hbm._on_use_item
    tph_eating.add_eating_hook(hbm,true,
    function(player, itemstack)
      return hbm_old(player, itemstack)
    end)
    -- tiku
    local tiku = minetest.registered_items["tech:tiku"]
    local tiku_old = tiku._on_use_item
    tph_eating.add_eating_hook(tiku,true,
    function(player, itemstack)
      return tiku_old(player, itemstack)
    end)
    -- soup
    local soup = minetest.registered_items["tech:soup"]
    tph_eating.add_eating_hook(soup,true,
    function(player, itemstack)
      return exile_eatdrink_playermade(itemstack, player)
    end)
  else -- v3
    -- herbal medicine
    local hbm = minetest.registered_items["tech:herbal_medicine"]
    local hbm_old = hbm.on_use
    minetest.override_item(hbm.name,{
      on_use = function() return end,
      _eating_success = function(player, itemstack)
        return hbm_old(itemstack, player)
      end,
    })
    tph_eating.add_eating_hook(hbm)
    -- tiku
    local tiku = minetest.registered_items["tech:tiku"]
    local tiku_old = tiku.on_use
    minetest.override_item(tiku.name,{
      on_use = function() return end,
      _eating_success = function(player, itemstack)
        return tiku_old(itemstack, player)
      end,
    })
    tph_eating.add_eating_hook(tiku)
    -- soup
    local soup = minetest.registered_items["tech:soup"]
    minetest.override_item(soup.name,{
      on_use = function() return end,
      _eating_success = function(player, itemstack)
        return exile_eatdrink_playermade(itemstack, player)
      end
    })
    tph_eating.add_eating_hook(soup)
  end
end)