--[[
    Minecraft-like Eating Mod for Minetest
    Copyright (C) 2024 TPH/TubberPupperHusker <damotrixrob@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
--]]

-- MOD SUPPORT FOR ANIMALIA (v0.7.1)
if not minetest.get_modpath("creatura") or not minetest.get_modpath("animalia") then
  return
end
minetest.register_on_mods_loaded(function()
  local food_list = {
    ["animalia:beef_cooked"] = {minetest.item_eat,8},
    ["animalia:mutton_cooked"] = {minetest.item_eat,6},
    ["animalia:rat_cooked"] = {minetest.item_eat,2},
    ["animalia:porkchop_cooked"] = {minetest.item_eat,7},
    ["animalia:poultry_cooked"] = {minetest.item_eat,6},
    ["animalia:venison_cooked"] = {minetest.item_eat,10}
  }
  -- do raw versions (all give 1 food)
  for name,value in pairs(food_list) do
    if string.match(name,"_cooked") then
      local new_name = string.gsub(name,"_cooked","")
      new_name = new_name.."_raw"
      food_list[new_name] = {minetest.item_eat,1}
    end
  end
  -- all fried eggs give 4 food
  local eggs_list = {"animalia:chicken_egg","animalia:turkey_egg","animalia:song_bird_egg"}
  for _,name in pairs(eggs_list) do
    name = name.."_fried"
    food_list[name] = {minetest.item_eat,4}
  end
  food_list["animalia:bucket_milk"] = {minetest.item_eat,8, "bucket:bucket_empty"}

  for name,value in pairs(food_list) do
    local func = value[1]
    table.remove(value,1)
    local args = value
    local override = {
      on_use = function() end,
      _eating_success = function(player, itemstack)
        local func_result = func(unpack(args))
        if type(func_result) == "function" then
          return func_result(itemstack, player)
        end
        return func_result
      end
    }
    minetest.override_item(name,override)
    tph_eating.add_eating_hook(name)
  end
end)