--[[
    Input-held Eating Mod for Minetest
    Copyright (C) 2024 TPH/TubberPupperHusker <damotrixrob@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
--]]

-- MOD SUPPORT FOR MTG (minetest_game)
if not minetest.get_modpath("default") or not minetest.get_modpath("farming") then
  return
end
minetest.register_on_mods_loaded(function()
  minetest.override_item("default:apple",{
    on_use = false,
    _eating_success = function(player, itemstack)
      minetest.item_eat(2)(itemstack, player)
      return itemstack
    end,
  })
  tph_eating.add_eating_hook("default:apple")
  minetest.override_item("default:blueberries",{
    on_use = false,
    _eating_success = function(player, itemstack)
      minetest.item_eat(2)(itemstack, player)
      return itemstack
    end,
  })
  tph_eating.add_eating_hook("default:blueberries")
  minetest.override_item("farming:bread",{
    on_use = false,
    _eating_success = function(player, itemstack)
      minetest.item_eat(5)(itemstack, player)
      return itemstack
    end,
  })
  tph_eating.add_eating_hook("farming:bread")
  -- silly
  if tph_eating.silly == true then
    minetest.override_item("default:diamond",{
      _eating_success = function(player, itemstack)
        minetest.item_eat(10)(itemstack,player)
        return itemstack
      end
    })
    tph_eating.add_eating_hook("default:diamond")
    minetest.override_item("default:gold_ingot",{
      _eating_success = function(player, itemstack)
        minetest.item_eat(5)(itemstack,player)
        return itemstack
      end
    })
    tph_eating.add_eating_hook("default:gold_ingot")
    minetest.override_item("default:mese_crystal",{
      _eating_success = function(player, itemstack)
        minetest.item_eat(15)(itemstack,player)
        return itemstack
      end
    })
    tph_eating.add_eating_hook("default:mese_crystal")
  end
end)