--[[
    Input-held Eating Mod for Minetest
    Copyright (C) 2024 TPH/TubberPupperHusker <damotrixrob@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
--]]

-- MOD SUPPORT FOR MOBS (2024-04-08, TenPlus1)
-- MOD SUPPORT FOR MOBS_ANIMAL (2024-02-27, TenPlus1)
if not (minetest.get_modpath("mobs") or minetest.get_modpath("mobs_animal")) then
  return
end
minetest.register_on_mods_loaded(function()
  local foodstuff = {}
  local function add_edible(name,def)
    if def.mod_origin == "mobs" or def.mod_origin == "mobs_animal" and type(def.on_use) == "function" then
      local grps = def.groups
      if (grps.food_meat_raw or grps.food_meat or grps.food_honey or grps.food_rat or grps.food_cheese
      or grps.food_butter or grps.food_egg_fried
      or name == "mobs:meatblock" or name == "mobs:meatblock_raw") then
        foodstuff[name] = def
      elseif grps.food_milk or grps.food_milk_glass then
        def = table.copy(def)
        def.sounds = def.sounds or {}
        def.sounds.eating_chew = {name = "tph_eating_gulp", gain = 0.6, pitch = {0.95,1.15}}
        foodstuff[name] = def
      end
    end
  end
  for name,nodedef in pairs(minetest.registered_nodes) do
    add_edible(name,nodedef)
  end
  for name,itemdef in pairs(minetest.registered_items) do
    add_edible(name,itemdef)
  end
  for name,def in pairs(foodstuff) do
    local old_use = def.on_use
    minetest.override_item(name,{
      on_use = false,
      _eating_success = function(player, itemstack)
        return old_use(itemstack, player)
      end,
    })
    tph_eating.add_eating_hook(name)
  end
end)