--[[
    Input-held Eating Mod for Minetest
    Copyright (C) 2024 TPH/TubberPupperHusker <damotrixrob@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
--]]

-- MOD SUPPORT FOR ANIMALIA (v0.7.1)
if not minetest.get_modpath("creatura") or not minetest.get_modpath("animalia") then
  return
end
minetest.register_on_mods_loaded(function()
  local foodstuff = {}
  local function add_edible(name,def)
    if string.match(name,"animalia:") and type(def.on_use) == "function" then
      if (def.groups.meat or string.match(name,"fried")) then
        foodstuff[name] = def
      elseif def.groups.food_milk then
        def = table.copy(def)
        def.sounds = def.sounds or {}
        def.sounds.eating_chew = tph_eating.slurp_sound
        foodstuff[name] = def
      end
    end
  end
  for name,nodedef in pairs(minetest.registered_nodes) do
    add_edible(name,nodedef)
  end
  for name,itemdef in pairs(minetest.registered_items) do
    add_edible(name,itemdef)
  end
  for _,def in pairs(foodstuff) do
    tph_eating.automated_on_use_override(def)
  end
end)