--[[
    Input-held Eating Mod for Exile
    Copyright (C) 2024 TPH/TubberPupperHusker <damotrixrob@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
--]]

-- MOD SUPPORT FOR EXILE
if not minetest.get_modpath("health") or not minetest.get_modpath("minimal") then
  return
end
-- v3 does not have minimal.merge_tables
-- MERGE_TABLES NOT OWNED OR COPYRIGHT BY TPH
local function merge_tables(t1,t2)
  if minimal and minimal.merge_tables then
    return minimal.merge_tables(t1,t2)
  end
  local new_table = table.copy(t1)
  --merge tables
  for key, value in pairs(t2) do
      new_table[key] = value
  end
  return new_table
end
HEALTH = HEALTH -- declare global
-----------------------------------
minetest.register_on_mods_loaded(function()
  local is_v4 = minetest.get_modpath("mapchunk_shepherd") and true or false
  -- only v4 has the mapchunk shepherd
  if is_v4 then
    -- v4 SETTINGS -------------------------------
    tph_eating.use_function = "_on_use_item"
    tph_eating.use_key = "aux1"
    -------------------------------------------
  end
  tph_eating.burping = false

  local look_through = is_v4 and merge_tables(HEALTH.food_table,HEALTH.bake_table) or merge_tables(food_table,bake_table)
  local edible = {}
  local function add_edible(name,def)
    if ((def.groups and def.groups.edible) or look_through[name] or
    (name == "tech:tiku" or name == "tech:herbal_medicine" or name == "tech:soup"))
    and not (name == "tech:mashed_anperla" or name == "tech:maraka_bread" or name == "tech:peeled_anperla"
    or name == "tech:peeled_anperla_burned") then
      if name == "tech:soup" or (string.match(name,"tech") and string.match(name,"tang")) then
        def = table.copy(def)
        def.sounds = def.sounds or {}
        def.sounds.eating_chew = table.copy(tph_eating.slurp_sound)
      end
      edible[name] = def
    end
  end
  for name,nodedef in pairs(minetest.registered_nodes) do
    add_edible(name,nodedef)
  end
  for name,itemdef in pairs(minetest.registered_items) do
    add_edible(name,itemdef)
  end
  for name,def in pairs(edible) do
    local old_use_name = is_v4 and tph_eating.use_function or "on_use"
    local old_use = def[old_use_name]
    local modify_old_use = false
    if is_v4 and name == "nodes_nature:snow" then
      modify_old_use = function(player, wielded_item, pointed_thing)
        if pointed_thing and pointed_thing.type == "node" then
          return minimal.slabs_combine(player, wielded_item, pointed_thing,
					"nodes_nature:snow_block")
        elseif not tph_eating.get_player_eating_data(player) then
          tph_eating.eating_func(player, wielded_item)
        end
      end
    end
    minetest.override_item(name,{
      [old_use_name] = modify_old_use,
      _eating_success = function(player, itemstack)
        if is_v4 and def.groups then
          if string.match(name,"nebiyi") then
            minetest.chat_send_player(player:get_player_name(),"Your stomach hurts terribly.")
          elseif string.match(name,"marbhan") then
            minetest.chat_send_player(player:get_player_name(),"This plant has a foul musty flavor.")
          end
          if def.groups.edible == 2 then
            return HEALTH.eatdrink_playermade(itemstack, player)
          else
            return HEALTH.eatdrink(itemstack, player)
          end
        end
        return old_use(itemstack, player, {type="object",ref=player})
      end,
      sounds = def.sounds,
    })
    tph_eating.add_eating_hook(name,is_v4 and not modify_old_use)
  end
end)