--[[
    Input-held Eating Mod for Minetest
    Copyright (C) 2024 TPH/TubberPupperHusker <damotrixrob@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
--]]

-- MOD SUPPORT FOR ETHERAL NG (2024-04-17, TenPlus1)
if not minetest.get_modpath("ethereal") then
  return
end
minetest.register_on_mods_loaded(function()
  local foodstuff = {}
  -- ethereal does not have a universal group for food -w-
  local list = {"banana","orange","nut","berry","olive","lemon","apple","stew","jelly","sushi","fugu",
    "teriyaki","shrimp","calamari","fish","sashimi","tuber","healing","onion","yellowleaves"}
  local function add_edible(name,def)
    if string.match(name,"ethereal:") and type(def.on_use) == "function" then
      if def.groups.drink or string.match(name,"potion") then
        def = table.copy(def)
        def.sounds = def.sounds or {}
        def.sounds.eating_chew = table.copy(tph_eating.slurp_sound)
        foodstuff[name] = def
      elseif def.groups.food_fish_raw then
        foodstuff[name] = def
      else
        for _,found in pairs(list) do
          if string.match(name,found) then
            foodstuff[name] = def
          end
        end
      end
    end
  end
  for name,nodedef in pairs(minetest.registered_nodes) do
    add_edible(name,nodedef)
  end
  for name,itemdef in pairs(minetest.registered_items) do
    add_edible(name,itemdef)
  end
  for name,def in pairs(foodstuff) do
    tph_eating.on_use_override(def,true)
  end
end)