--[[
    Input-held Eating Mod for Minetest
    Copyright (C) 2024 TPH/TubberPupperHusker <damotrixrob@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
--]]

-- MOD SUPPORT FOR MTG (minetest_game)
if not minetest.get_modpath("default") or not minetest.get_modpath("farming") then
  return
end
minetest.register_on_mods_loaded(function()
  local consumables = {"default:apple","default:blueberries","farming:bread"}
  for _,name in pairs(consumables) do
    tph_eating.on_use_override(name,true)
  end
  -- silly
  if not tph_eating.silly == true then
    return
  end
  local silly_consume = {
    ["default:diamond"] = 10,
    ["default:gold_ingot"] = 5,
    ["default:mese_crystal"] = 15
  }
  for name,amt in pairs(silly_consume) do
    local def = minetest.registered_items[name]
    if def then
      minetest.override_item(name,{
        on_use = false,
        _eating_success = function(player, itemstack)
          return minetest.item_eat(amt)(itemstack, player)
        end
      })
      tph_eating.add_eating_hook(name)
    end
  end
end)