--[[
    Input-held Eating Mod for Minetest
    Copyright (C) 2024 TPH/TubberPupperHusker <damotrixrob@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
--]]

-- MOD SUPPORT FOR MOBS (2024-04-26b, TenPlus1)
-- MOD SUPPORT FOR MOBS_ANIMAL (2024-04-22, TenPlus1)
-- MOD SUPPORT FOR BEES (2024-03-12, TenPlus1)
-- MOD SUPPORT FOR NSSM (2024-04-20, TenPlus1)
if not (minetest.get_modpath("mobs") or minetest.get_modpath("mobs_animal") or minetest.get_modpath("bees")
  or minetest.get_modpath("nssm")) then
  return
end
minetest.register_on_mods_loaded(function()
  local foodstuff = {}
  local function add_edible(name,def)
    if (def.mod_origin == "mobs" or def.mod_origin == "mobs_animal" or def.mod_origin == "bees"
    or def.mod_origin == "nssm")
    and type(def.on_use) == "function" then
      local grps = def.groups
      if (grps.food_meat_raw or grps.food_meat or grps.food_honey or grps.food_rat or grps.food_cheese
      or grps.food_butter or grps.food_egg_fried
      or name == "mobs:meatblock" or name == "mobs:meatblock_raw" or name == "bees:honey_comb") then
        foodstuff[name] = def
      elseif grps.food_milk or grps.food_milk_glass or name == "bees:bottle_honey" then
        def = table.copy(def)
        def.sounds = def.sounds or {}
        def.sounds.eating_chew = table.copy(tph_eating.slurp_sound)
        foodstuff[name] = def
      end
    end
  end
  for name,nodedef in pairs(minetest.registered_nodes) do
    add_edible(name,nodedef)
  end
  for name,itemdef in pairs(minetest.registered_items) do
    add_edible(name,itemdef)
  end
  for name,def in pairs(foodstuff) do
    tph_eating.on_use_override(def,true)
  end
end)