--[[
    Input-held Eating Mod for Minetest
    Copyright (C) 2024 TPH/TubberPupperHusker <damotrixrob@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
--]]

-- MOD SUPPORTS FOR; -- mods created by Liil
-- WILHELMINES ANIMAL WORLD (1.8.1)
-- WILHELMINES LIVING FLOATLANDS (1.84)
-- WILHELMINES LIVING CAVES (0.81)
-- WILHELMINES LIVING CAVES MOBS (1.2)
-- WILHELMINES LIVING DESERT (1.42)
-- WILHELMINES NATURAL BIOMES (1.48)
-- WILHELMINES PEOPLE (0.83 BETA)
-- NATIVE VILLAGES (0.92)
-- WILHELMINES MARINARA (0.71)
-- WILHELMINES MARINARA MOBS (1.21)
local mod_list = {
  ["animalworld"] = true,
  ["livingfloatlands"] = true,
  ["livingcaves"] = true,
  ["livingcavesmobs"] = true,
  ["livingdesert"] = true,
  ["naturalbiomes"] = true,
  ["people"] = true,
  ["nativevillages"] = true,
  ["marinara"] = true,
  ["marinaramobs"] = true,
}
local function has_support()
  for name,_ in pairs(mod_list) do
    if minetest.get_modpath(name) then
      return true
    end
  end
end
if not has_support() then return end
local function is_supported(def)
  if mod_list[def.mod_origin] then
    return true
  end
end
minetest.register_on_mods_loaded(function()
  local foodstuff = {}
  local function add_edible(name,def)
    if is_supported(def) and type(def.on_use) == "function" then
      if def.groups.food_milk or def.groups.drink then
        def = table.copy(def)
        def.sounds = def.sounds or {}
        def.sounds.eating_chew = table.copy(tph_eating.slurp_sound)
        foodstuff[name] = def
      elseif def.groups.food or def.groups.food_meat or def.groups.food_meat_raw or def.groups.food_rat
      or def.groups.food_butter or def.groups.food_cheese or def.groups.food_egg_fried or def.groups.food_mushroom
      or string.match(name,"root") or string.match(name,"pine") or string.match(name,"nut") or string.match(name,"berry")
      or string.match(name,"rose") or string.match(name,"olive") or string.match(name,"banana")
      or string.match(name,"humanmeat") then
        -- why does naturalbiome have so many improperly organized foods...
        foodstuff[name] = def
      end
    end
  end
  for name,nodedef in pairs(minetest.registered_nodes) do
    add_edible(name,nodedef)
  end
  for name,itemdef in pairs(minetest.registered_items) do
    add_edible(name,itemdef)
  end
  for name,def in pairs(foodstuff) do
    tph_eating.on_use_override(def,true)
  end
end)