-- no exact point to this really, but it's nice to have a warning before things get ugly
if core.global_exists("typeof") then
    error("typeof: global exists already - causing crash to prevent incompatibility or issues")
end

-- returns a more complex assortment of types
-- e.g. vector will be "vector" instead of "table" or player will be "player" instead of "userdata"
-- sorted into: main type, subdivision type (2 return values)
-- type, subdivision = typeof(value)
-- subdivision can be nil
function typeof(value)
    if type(value) == "table" then
        -- a vector
        if vector and vector.check(value) or not vector and
          -- if before vector is a thing (<5.5.0)
          type(value.x) == "number" and type(value.y) == "number" and type(value.z) == "number" then
            return "vector"
        end
        -- special tables with metatables ; voxel area
        local special = getmetatable(value)
        if special then
            -- voxelarea
            if type(special.getExtent) == "function" and type(special.getVolume) == "function" and
              type(special.contains) == "function" then
                return "voxelarea"
            end
        end
    -- players, objects, metarefs
    elseif type(value) == "userdata" then
        -- player
        if core.is_player(value) and type(value.get_player_name) == "function" then
            return "player"
        -- object
        elseif type(value.get_properties) == "function" and type(value.set_animation) == "function" and
          type(value.set_detach) == "function" then
            return "object"
        -- invref
        elseif type(value.set_width) == "function" and type(value.set_list) == "function" and
          type(value.set_size) == "function" then
              return "inventory"
        -- itemstack
        elseif type(value.get_stack_max) == "function" and type(value.get_short_description) == "function" and
          type(value.get_definition) == "function" then
            return "itemstack"
        -- areastore
        elseif type(value.get_area) == "function" and type(value.remove_area) == "function" and
          type(value.get_areas_for_pos) == "function" then
            return "areastore"
        -- voxelmanip
        elseif type(value.read_from_map) == "function" and type(value.get_node_at) == "function" and
          type(value.get_data) == "function" then
            return "voxelmanip"
        -- meta
        elseif type(value.contains) == "function" and type(value.to_table) == "function" and
          type(value.set_int) == "function" then
            -- specific meta types;
            -- ItemStackMetaRef
            if type(value.set_tool_capabilities) == "function" then
                return "meta", "itemstack"
            -- NodeMetaRef
            elseif type(value.get_inventory) == "function" then
                return "meta", "node"
            end
            -- StorageRef and PlayerMetaRef have no unique detectable methods and thus have no subdivisions
            return "meta"
        -- NodeTimerRef
        elseif type(value.get_timeout) == "function" and type(value.stop) == "function" and
          type(value.set) == "function" and type(value.get_elapsed) == "function" then
            return "nodetimer"
        -- Settings
        elseif type(value.get_flags) == "function" and type(value.get_pos) == "function" and  
          type(value.has) == "function" then
            return "settings"
        end
    -- permit returning whether or not this is a float (decimal points) or integer
    elseif type(value) == "number" then
        if math.ceil(value) ~= value then
            return "number", "float"
        else
            return "number", "integer"
        end
    end
    -- default
    return type(value)
end

-- uncomment this to test *almost* each typeof
--[[
core.log(dump({typeof(1)}))
core.log(dump({typeof(1.2)}))
core.log(typeof(AreaStore()))
core.log(typeof(VoxelArea()))
core.log(typeof(core.settings))
core.log(typeof(vector.new(0,0,0)))
core.log(typeof(ItemStack()))
core.log(dump({typeof(ItemStack():get_meta())}))
core.after(1, function()
    core.log(typeof(VoxelManip(vector.new(0,0,0),vector.new(10,10,10))))
    local meta = core.get_meta(vector.new(0,0,0))
    core.log(dump({typeof(meta)}))
    core.log(typeof(meta:get_inventory()))
    core.log(typeof(core.get_node_timer(vector.new(0,0,0))))
end)
--]]