-- no exact point to this really, but it's nice to have a warning before things get ugly
if core.global_exists("typeof") then
    error("typeof: global exists already - causing crash to prevent incompatibility or issues")
end

core.log("info", "typeof: loading getmetatable references")

local modstorage = core.get_mod_storage()

local refs = {
    areastore = getmetatable(AreaStore()),
    settings = getmetatable(core.settings),
    meta = {
        storage = getmetatable(modstorage)
    }
}
local tablerefs = {}

-- returns a more complex assortment of types
-- e.g. vector will be "vector" instead of "table" or player will be "player" instead of "userdata"
-- sorted into: main type, subdivision type (2 return values)
-- type, subdivision = typeof(value)
-- subdivision can be nil
function typeof(value)
    if type(value) == "table" then
        -- a vector
        -- voxelarea has the same values as a regular vector, compatibility for <5.5.0
        if vector and vector.check and vector.check(value) or (not (vector.check or value.ystride) and
          -- if before vector is a thing (<5.5.0)
          type(value.x) == "number" and type(value.y) == "number" and type(value.z) == "number") then
            return "vector"
        end
        -- special tables with metatables ; voxel area
        local special = getmetatable(value)
        if special == tablerefs.voxelarea then
            return "voxelarea"
        -- will tell you that it has a metatable
        elseif special then
            return "table", "metatable"
        end
        -- default
        return "table"
    -- players, objects, metarefs
    elseif type(value) == "userdata" then
        -- player
        if core.is_player(value) then
            return "player"
        -- object
        elseif type(value.get_properties) == "function" and type(value.set_animation) == "function" and
          type(value.set_detach) == "function" then
            return "object"
        end
        -- check metatable references
        local metaref = getmetatable(value)
        if metaref then
            -- check list of userdata metatable references
            for name, refdata in pairs(refs) do
                if refdata == metaref then
                    return name
                end
            end
            -- metadataref
            if type(value.contains) == "function" and type(value.to_table) == "function" and
              type(value.set_int) == "function" then
                for name, refdata in pairs(refs.meta) do
                    if refdata == metaref then
                        return "meta", name
                    end
                end
                -- hmm... couldn't figure out what type of metadataref this was
                return "meta"
            end
        end
        -- default
        return "userdata"
    -- permit returning whether or not this is a float (decimal points) or integer
    elseif type(value) == "number" then
        if math.ceil(value) ~= value then
            return "number", "float"
        else
            return "number", "integer"
        end
    end
    -- default
    return type(value)
end

-- itemstack
local item = ItemStack(next(core.registered_items).name)
refs.itemstack = getmetatable(item)
refs.meta.itemstack = getmetatable(item:get_meta())
-- get post-load metatable references
core.register_on_mods_loaded(function()
    -- node specific (ran on a delay for world load)
    core.after(0.01, function()
        -- positions
        local positions = {vector.new(0,0,0), vector.new(1,1,1)}
        refs.voxelmanip = getmetatable(VoxelManip(positions[1], positions[2]))
        tablerefs.voxelarea = VoxelArea and getmetatable(
        VoxelArea:new({MinEdge = positions[1], MaxEdge = positions[2]}))
        refs.nodetimer = getmetatable(core.get_node_timer(positions[1]))
        local meta = core.get_meta(positions[1])
        refs.meta.node = getmetatable(meta)
        refs.inventory = getmetatable(meta:get_inventory())
        -- debug message
        core.log("info", "typeof: finished loading metatable references (excluding player meta)")
    end)
end)

core.register_on_joinplayer(function(plr)
    if refs.meta.player then return end
    refs.meta.player = getmetatable(plr:get_meta())
    core.log("info", "typeof: loaded player meta metatable reference")
    -- awful debug to check values
    --[[
    for e,v in pairs(refs) do
        core.log(e.." : "..tostring(v))
        if e == "meta" then
            for e2,v2 in pairs(v) do
                core.log(e.." ;; "..e2.." : "..tostring(v2))
            end
        end
    end
    --]]
    -- check if player meta metatable has been successfully added
    --[[
    core.after(1, function()
        core.log(dump({typeof(plr:get_meta())}))
    end)
    --]]
end)

-- uncomment this to test *almost* each typeof

--[[
core.after(3, function()
    local pos = {vector.new(0,0,0), vector.new(1,1,1)}
    core.log(dump({typeof(1)}))
    core.log(dump({typeof(1.2)}))
    core.log(typeof(AreaStore()))
    core.log(typeof(VoxelArea:new(pos[1], pos[2])))
    core.log(typeof(core.settings))
    core.log(typeof(vector.new(0,0,0)))
    local item = ItemStack(next(core.registered_items).name)
    core.log(typeof(item))
    core.log(dump({typeof(item:get_meta())}))
    core.log(dump({typeof(modstorage)}))
    core.log(typeof(VoxelManip(vector.new(0,0,0),vector.new(10,10,10))))
    local meta = core.get_meta(vector.new(0,0,0))
    core.log(dump({typeof(meta)}))
    core.log(typeof(meta:get_inventory()))
    core.log(typeof(core.get_node_timer(vector.new(0,0,0))))
end)
--]]