-- cropocalypse/init.lua

-- Wooden Bowl

minetest.register_craftitem("cropocalypse:wooden_bowl", {
	description = ("Wooden Bowl"),
	inventory_image = "cropocalypse_wooden_bowl.png",
	groups = {flammable = 2},
})

minetest.register_craft({
	output = "cropocalypse:wooden_bowl 3",
	recipe = {
		{"group:wood", "", "group:wood"},
		{"", "group:wood", ""},
	}
})

-- Sliced Apples

minetest.register_craftitem("cropocalypse:sliced_apples", {
	description = ("Sliced Apples"),
	inventory_image = "cropocalypse_sliced_apples.png",
	on_use = minetest.item_eat(2),
	groups = {food_sliced_apples = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:sliced_apples 4",
	recipe = {"default:apple", "default:apple", "default:apple"}
})

-- Apple Cider Vinegar

minetest.register_craftitem("cropocalypse:apple_cider_vinegar", {
	description = ("Apple Cider Vinegar"),
	inventory_image = "cropocalypse_apple_cider_vinegar.png",
	on_use = minetest.item_eat(1),
	groups = {food_apple_cider_vinegar = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:apple_cider_vinegar",
	recipe = {"cropocalypse:sliced_apples", "cropocalypse:sliced_apples", "cropocalypse:sugar", "vessels:glass_bottle"}
})

-- Saltwater Kelp Jar

minetest.register_craftitem("cropocalypse:saltwater_kelp_jar", {
	description = ("Saltwater Kelp Jar"),
	inventory_image = "cropocalypse_saltwater_kelp_jar.png",
	on_use = minetest.item_eat(1),
	groups = {food_saltwater_kelp_jar = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:saltwater_kelp_jar",
	recipe = {"default:sand_with_kelp", "default:sand_with_kelp", "default:sand_with_kelp", "vessels:glass_bottle"}
})

-- Multiplying Saltwater Kelp Jars Because Kelp Is Not Currently Renewable

minetest.register_craftitem("cropocalypse:saltwater_kelp_jar", {
	description = ("Saltwater Kelp Jar"),
	inventory_image = "cropocalypse_saltwater_kelp_jar.png",
	on_use = minetest.item_eat(1),
	groups = {food_saltwater_kelp_jar = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:saltwater_kelp_jar 3",
	recipe = {"cropocalypse:saltwater_kelp_jar", "vessels:glass_bottle", "vessels:glass_bottle"}
})

-- Kelp Agar

minetest.register_craftitem("cropocalypse:kelp_agar", {
	description = ("Kelp Agar"),
	inventory_image = "cropocalypse_kelp_agar.png",
	on_use = minetest.item_eat(1),
	groups = {food_kelp_agar = 1, flammable = 1},
})

minetest.register_craft({
	type = "cooking",
	output = "cropocalypse:kelp_agar",
	recipe = "cropocalypse:saltwater_kelp_jar",
})

-- Register Wild Carrot Node

minetest.register_node("cropocalypse:carrot_wild", {
	description = ("Wild Carrot"),
	drawtype = "plantlike",
	waving = 1,
	tiles = {"cropocalypse_carrot_wild.png"},
	inventory_image = "cropocalypse_carrot_wild.png",
	wield_image = "cropocalypse_carrot_wild.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {snappy = 3, attached_node = 1, flammable = 4},
	drop = "cropocalypse:seed_carrot",
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = {-6 / 16, -8 / 16, -6 / 16, 6 / 16, 5 / 16, 6 / 16},
	},
})

-- Register Wild Carrot Decoration

minetest.register_decoration({
	name = "cropocalypse:carrot_wild",
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 50, y = 50, z = 50},
		seed = 2703,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"grassland"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:carrot_wild",
})

-- Carrot Plant Farming

farming.register_plant("cropocalypse:carrot", {
	description = ("Carrot Seed"),
	harvest_description = ("Carrot Root"),
	paramtype2 = "meshoptions",
	inventory_image = "cropocalypse_carrot_seed.png",
	steps = 8,
	minlight = 13,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland", "desert"},
	groups = {food_carrot = 1, flammable = 4},
	place_param2 = 3,
})

-- Carrot Item Data

minetest.register_craftitem("cropocalypse:carrot", {
	description = ("Carrot"),
	inventory_image = "cropocalypse_carrot.png",
	wield_image = "cropocalypse_carrot.png",
	paramtype = "meshoptions",
	groups = {food_carrot = 1, flammable = 4},
	on_use = minetest.item_eat(1),
})

-- Sliced Carrots

minetest.register_craftitem("cropocalypse:sliced_carrots", {
	description = ("Sliced Carrots"),
	inventory_image = "cropocalypse_sliced_carrots.png",
	on_use = minetest.item_eat(2),
	groups = {food_sliced_carrots = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:sliced_carrots 2",
	recipe = {"cropocalypse:carrot", "cropocalypse:carrot", "cropocalypse:carrot"}
})

-- Register Wild Potato Node

minetest.register_node("cropocalypse:potato_wild", {
	description = ("Wild Potato"),
	drawtype = "plantlike",
	waving = 1,
	tiles = {"cropocalypse_potato_wild.png"},
	inventory_image = "cropocalypse_potato_wild.png",
	wield_image = "cropocalypse_potato_wild.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {snappy = 3, attached_node = 1, flammable = 4},
	drop = "cropocalypse:seed_potato",
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = {-6 / 16, -8 / 16, -6 / 16, 6 / 16, 5 / 16, 6 / 16},
	},
})

-- Register Wild Potato Decoration

minetest.register_decoration({
	name = "cropocalypse:potato_wild",
	deco_type = "simple",
	place_on = {"default:dirt_with_rainforest_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 50, y = 50, z = 50},
		seed = 8643,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"rainforest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:potato_wild",
})

-- Sweet Potato Plant Farming

farming.register_plant("cropocalypse:potato", {
	description = ("Potato Seed"),
	harvest_description = ("Sweet Potato"),
	paramtype2 = "meshoptions",
	inventory_image = "cropocalypse_potato_seed.png",
	steps = 8,
	minlight = 13,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland", "desert"},
	groups = {food_potato = 1, flammable = 4},
	place_param2 = 3,
})

-- Sweet Potato Item Data

minetest.register_craftitem("cropocalypse:potato", {
	description = ("Sweet Potato"),
	inventory_image = "cropocalypse_potato.png",
	wield_image = "cropocalypse_potato.png",
	paramtype = "meshoptions",
	groups = {food_potato = 1, flammable = 4},
	on_use = minetest.item_eat(1),
})

-- Mashed Potatoes

minetest.register_craftitem("cropocalypse:mashed_potatoes", {
	description = ("Mashed Potatoes"),
	inventory_image = "cropocalypse_mashed_potatoes.png",
	on_use = minetest.item_eat(4),
	groups = {food_mashed_potatoes = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:mashed_potatoes",
	recipe = {"cropocalypse:wooden_bowl", "cropocalypse:potato", "cropocalypse:potato", "cropocalypse:potato"}
})


-- Register Wild Beet Node

minetest.register_node("cropocalypse:beet_wild", {
	description = ("Wild Beet"),
	drawtype = "plantlike",
	waving = 1,
	tiles = {"cropocalypse_beet_wild.png"},
	inventory_image = "cropocalypse_beet_wild.png",
	wield_image = "cropocalypse_beet_wild.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {snappy = 3, attached_node = 1, flammable = 4},
	drop = "cropocalypse:seed_beet",
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = {-6 / 16, -8 / 16, -6 / 16, 6 / 16, 5 / 16, 6 / 16},
	},
})

-- Register Wild Beet Decoration

minetest.register_decoration({
	name = "cropocalypse:beet_wild",
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 50, y = 50, z = 50},
		seed = 9977,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"grassland"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:beet_wild",
})

-- Sugar Beet Plant Farming

farming.register_plant("cropocalypse:beet", {
	description = ("Beet Seed"),
	harvest_description = ("Sugar Beet"),
	inventory_image = "cropocalypse_beet_seed.png",
	steps = 8,
	minlight = 13,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland", "desert"},
	groups = {food_beet = 1, flammable = 4},
})

-- Sugar Beet Item Data

minetest.register_craftitem("cropocalypse:beet", {
	description = ("Sugar Beet"),
	inventory_image = "cropocalypse_beet.png",
	wield_image = "cropocalypse_beet.png",
	paramtype = "meshoptions",
	groups = {food_beet = 1, flammable = 4},
	on_use = minetest.item_eat(1),
})

-- Sugar

minetest.register_craftitem("cropocalypse:sugar", {
	description = ("Sugar"),
	inventory_image = "cropocalypse_sugar.png",
	on_use = minetest.item_eat(1),
	groups = {food_sugar = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:sugar 2",
	recipe = {"cropocalypse:beet", "cropocalypse:beet", "cropocalypse:beet"}
})

-- Register Wild Soybean Node

minetest.register_node("cropocalypse:soybean_wild", {
	description = ("Wild Soybean"),
	drawtype = "plantlike",
	waving = 1,
	tiles = {"cropocalypse_soybean_wild.png"},
	inventory_image = "cropocalypse_soybean_wild.png",
	wield_image = "cropocalypse_soybean_wild.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {snappy = 3, attached_node = 1, flammable = 4},
	drop = "cropocalypse:seed_soybean",
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = {-6 / 16, -8 / 16, -6 / 16, 6 / 16, 5 / 16, 6 / 16},
	},
})

-- Register Wild Soybean Decoration

minetest.register_decoration({
	name = "cropocalypse:soybean_wild",
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 50, y = 50, z = 50},
		seed = 1071,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"deciduous_forest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:soybean_wild",
})

-- Soybean Plant Farming

farming.register_plant("cropocalypse:soybean", {
	description = ("Soybean Seed"),
	harvest_description = ("Soybean"),
	inventory_image = "cropocalypse_soybean_seed.png",
	steps = 8,
	minlight = 13,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland", "desert"},
	groups = {food_soybean = 1, flammable = 4},
})

-- Soybean Item Data

minetest.register_craftitem("cropocalypse:soybean", {
	description = ("Soybean"),
	inventory_image = "cropocalypse_soybean.png",
	wield_image = "cropocalypse_soybean.png",
	paramtype = "meshoptions",
	groups = {food_soybean = 1, flammable = 4},
	on_use = minetest.item_eat(1),
})

-- Soybean Water

minetest.register_craftitem("cropocalypse:soybean_water", {
	description = ("Soybean Water"),
	inventory_image = "cropocalypse_soybean_water.png",
	on_use = minetest.item_eat(1),
	groups = {food_soybean_water = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:soybean_water",
	recipe = {"cropocalypse:soybean", "cropocalypse:soybean", "cropocalypse:soybean", "vessels:glass_bottle"}
})

-- Soy Milk

minetest.register_craftitem("cropocalypse:soy_milk", {
	description = ("Soy Milk"),
	inventory_image = "cropocalypse_soy_milk.png",
	on_use = minetest.item_eat(4),
	groups = {food_soy_milk = 1, flammable = 1},
})

minetest.register_craft({
	type = "cooking",
	output = "cropocalypse:soy_milk",
	recipe = "cropocalypse:soybean_water",
})

-- Soy Butter

minetest.register_craftitem("cropocalypse:soy_butter", {
	description = ("Soy Butter"),
	inventory_image = "cropocalypse_soy_butter.png",
	on_use = minetest.item_eat(4),
	groups = {food_soy_butter = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:soy_butter",
	recipe = {"cropocalypse:wooden_bowl", "cropocalypse:soy_milk", "cropocalypse:apple_cider_vinegar", "cropocalypse:kelp_agar"}
})

-- Register Wild Garlic Node

minetest.register_node("cropocalypse:garlic_wild", {
	description = ("Wild Garlic"),
	drawtype = "plantlike",
	waving = 1,
	tiles = {"cropocalypse_garlic_wild.png"},
	inventory_image = "cropocalypse_garlic_wild.png",
	wield_image = "cropocalypse_garlic_wild.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {snappy = 3, attached_node = 1, flammable = 4},
	drop = "cropocalypse:seed_garlic",
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = {-6 / 16, -8 / 16, -6 / 16, 6 / 16, 5 / 16, 6 / 16},
	},
})

-- Register Wild Garlic Decoration

minetest.register_decoration({
	name = "cropocalypse:garlic_wild",
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 50, y = 50, z = 50},
		seed = 9277,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"deciduous_forest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:garlic_wild",
})

-- Garlic Plant Farming

farming.register_plant("cropocalypse:garlic", {
	description = ("Garlic Seed"),
	harvest_description = ("Garlic"),
	paramtype2 = "meshoptions",
	inventory_image = "cropocalypse_garlic_seed.png",
	steps = 8,
	minlight = 13,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland", "desert"},
	groups = {food_garlic = 1, flammable = 4},
	place_param2 = 3,
})

-- Garlic Item Data

minetest.register_craftitem("cropocalypse:garlic", {
	description = ("Garlic"),
	inventory_image = "cropocalypse_garlic.png",
	wield_image = "cropocalypse_garlic.png",
	paramtype = "meshoptions",
	groups = {food_garlic = 1, flammable = 4},
	on_use = minetest.item_eat(1),
})

-- Raw Garlic Bread

minetest.register_craftitem("cropocalypse:raw_garlic_bread", {
	description = ("Raw Garlic Bread"),
	inventory_image = "cropocalypse_raw_garlic_bread.png",
	on_use = minetest.item_eat(3),
	groups = {food_raw_garlic_bread = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:raw_garlic_bread",
	recipe = {"farming:bread", "cropocalypse:soy_butter", "cropocalypse:garlic"}
})

-- Cooked Garlic Bread

minetest.register_craftitem("cropocalypse:cooked_garlic_bread", {
	description = ("Cooked Garlic Bread"),
	inventory_image = "cropocalypse_cooked_garlic_bread.png",
	on_use = minetest.item_eat(8),
	groups = {food_cooked_garlic_bread = 1, flammable = 1},
})

minetest.register_craft({
	type = "cooking",
	output = "cropocalypse:cooked_garlic_bread",
	recipe = "cropocalypse:raw_garlic_bread",
})

-- Register Wild Morel Mushroom Node

minetest.register_node("cropocalypse:morel_mushroom_wild", {
	description = ("Wild Morel Mushroom"),
	drawtype = "plantlike",
	waving = 0,
	tiles = {"cropocalypse_morel_mushroom_wild.png"},
	inventory_image = "cropocalypse_morel_mushroom_wild.png",
	wield_image = "cropocalypse_morel_mushroom_wild.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {snappy = 3, attached_node = 1, flammable = 4},
	drop = "cropocalypse:seed_morel_mushroom",
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = {-6 / 16, -8 / 16, -6 / 16, 6 / 16, 5 / 16, 6 / 16},
	},
})

-- Register Wild Morel Mushroom Decoration

minetest.register_decoration({
	name = "cropocalypse:morel_mushroom_wild",
	deco_type = "simple",
	place_on = {"default:dirt_with_coniferous_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 50, y = 50, z = 50},
		seed = 3961,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"coniferous_forest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:morel_mushroom_wild",
})

-- Morel Mushroom Fungus Farming

farming.register_plant("cropocalypse:morel_mushroom", {
	description = ("Morel Mushroom Spore"),
	harvest_description = ("Morel Mushroom"),
	paramtype2 = "meshoptions",
	inventory_image = "cropocalypse_morel_mushroom_seed.png",
	steps = 8,
	minlight = 0,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland", "desert"},
	groups = {food_morel_mushroom = 1, flammable = 4},
	place_param2 = 3,
})

-- Morel Mushroom Item Data

minetest.register_craftitem("cropocalypse:morel_mushroom", {
	description = ("Morel Mushroom"),
	inventory_image = "cropocalypse_morel_mushroom.png",
	wield_image = "cropocalypse_morel_mushroom.png",
	paramtype = "meshoptions",
	groups = {food_morel_mushroom = 1, flammable = 4},
	on_use = minetest.item_eat(1),
})

-- Register Wild Oyster Mushroom Node

minetest.register_node("cropocalypse:oyster_mushroom_wild", {
	description = ("Wild Oyster Mushroom"),
	drawtype = "plantlike",
	waving = 0,
	tiles = {"cropocalypse_oyster_mushroom_wild.png"},
	inventory_image = "cropocalypse_oyster_mushroom_wild.png",
	wield_image = "cropocalypse_oyster_mushroom_wild.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {snappy = 3, attached_node = 1, flammable = 4},
	drop = "cropocalypse:seed_oyster_mushroom",
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = {-6 / 16, -8 / 16, -6 / 16, 6 / 16, 5 / 16, 6 / 16},
	},
})

-- Register Wild Oyster Mushroom Decoration

minetest.register_decoration({
	name = "cropocalypse:oyster_mushroom_wild",
	deco_type = "simple",
	place_on = {"default:dirt_with_coniferous_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 50, y = 50, z = 50},
		seed = 1673,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"coniferous_forest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:oyster_mushroom_wild",
})

-- Oyster Mushroom Fungus Farming

farming.register_plant("cropocalypse:oyster_mushroom", {
	description = ("Oyster Mushroom Spore"),
	harvest_description = ("Oyster Mushroom"),
	paramtype2 = "meshoptions",
	inventory_image = "cropocalypse_oyster_mushroom_seed.png",
	steps = 8,
	minlight = 0,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland", "desert"},
	groups = {food_oyster_mushroom = 1, flammable = 4},
	place_param2 = 3,
})

-- Oyster Mushroom Item Data

minetest.register_craftitem("cropocalypse:oyster_mushroom", {
	description = ("Oyster Mushroom"),
	inventory_image = "cropocalypse_oyster_mushroom.png",
	wield_image = "cropocalypse_oyster_mushroom.png",
	paramtype = "meshoptions",
	groups = {food_oyster_mushroom = 1, flammable = 4},
	on_use = minetest.item_eat(1),
})

-- Register Wild Shiitake Mushroom Node

minetest.register_node("cropocalypse:shiitake_mushroom_wild", {
	description = ("Wild Skiitake Mushroom"),
	drawtype = "plantlike",
	waving = 0,
	tiles = {"cropocalypse_shiitake_mushroom_wild.png"},
	inventory_image = "cropocalypse_shiitake_mushroom_wild.png",
	wield_image = "cropocalypse_shiitake_mushroom_wild.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {snappy = 3, attached_node = 1, flammable = 4},
	drop = "cropocalypse:seed_shiitake_mushroom",
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = {-6 / 16, -8 / 16, -6 / 16, 6 / 16, 5 / 16, 6 / 16},
	},
})

-- Register Wild Shiitake Mushroom Decoration

minetest.register_decoration({
	name = "cropocalypse:shiitake_mushroom_wild",
	deco_type = "simple",
	place_on = {"default:dirt_with_coniferous_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 50, y = 50, z = 50},
		seed = 1183,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"coniferous_forest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:shiitake_mushroom_wild",
})

-- Shiitake Mushroom Fungus Farming

farming.register_plant("cropocalypse:shiitake_mushroom", {
	description = ("Shiitake Mushroom Spore"),
	harvest_description = ("Shiitake Mushroom"),
	paramtype2 = "meshoptions",
	inventory_image = "cropocalypse_shiitake_mushroom_seed.png",
	steps = 8,
	minlight = 0,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland", "desert"},
	groups = {food_shiitake_mushroom = 1, flammable = 4},
	place_param2 = 3,
})

-- Shiitake Mushroom Item Data

minetest.register_craftitem("cropocalypse:shiitake_mushroom", {
	description = ("Shiitake Mushroom"),
	inventory_image = "cropocalypse_shiitake_mushroom.png",
	wield_image = "cropocalypse_shiitake_mushroom.png",
	paramtype = "meshoptions",
	groups = {food_shiitake_mushroom = 1, flammable = 4},
	on_use = minetest.item_eat(1),
})

-- Register Wild White Button Mushroom Node

minetest.register_node("cropocalypse:white_button_mushroom_wild", {
	description = ("Wild White Button Mushroom"),
	drawtype = "plantlike",
	waving = 0,
	tiles = {"cropocalypse_white_button_mushroom_wild.png"},
	inventory_image = "cropocalypse_white_button_mushroom_wild.png",
	wield_image = "cropocalypse_white_button_mushroom_wild.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {snappy = 3, attached_node = 1, flammable = 4},
	drop = "cropocalypse:seed_white_button_mushroom",
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed",
		fixed = {-6 / 16, -8 / 16, -6 / 16, 6 / 16, 5 / 16, 6 / 16},
	},
})

-- Register Wild White Button Mushroom Decoration

minetest.register_decoration({
	name = "cropocalypse:white_button_mushroom_wild",
	deco_type = "simple",
	place_on = {"default:dirt_with_coniferous_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 50, y = 50, z = 50},
		seed = 9303,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"coniferous_forest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:white_button_mushroom_wild",
})

-- White Button Mushroom Fungus Farming

farming.register_plant("cropocalypse:white_button_mushroom", {
	description = ("White Button Mushroom Spore"),
	harvest_description = ("White Button Mushroom"),
	paramtype2 = "meshoptions",
	inventory_image = "cropocalypse_white_button_mushroom_seed.png",
	steps = 8,
	minlight = 0,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland", "desert"},
	groups = {food_white_button_mushroom = 1, flammable = 4},
	place_param2 = 3,
})

-- White Button Mushroom Item Data

minetest.register_craftitem("cropocalypse:white_button_mushroom", {
	description = ("White Button Mushroom"),
	inventory_image = "cropocalypse_white_button_mushroom.png",
	wield_image = "cropocalypse_white_button_mushroom.png",
	paramtype = "meshoptions",
	groups = {food_white_button_mushroom = 1, flammable = 4},
	on_use = minetest.item_eat(1),
})

-- Mushroom Surprise

minetest.register_craftitem("cropocalypse:mushroom_surprise", {
	description = ("Mushroom Surprise"),
	inventory_image = "cropocalypse_mushroom_surprise.png",
	on_use = minetest.item_eat(6),
	groups = {food_mushroom_surprise = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:mushroom_surprise",
	recipe = {"cropocalypse:wooden_bowl", "cropocalypse:morel_mushroom", "cropocalypse:oyster_mushroom", "cropocalypse:shiitake_mushroom", "cropocalypse:white_button_mushroom"}
})

-- Cropocalypse Dye Recipes

minetest.register_craft({
	output = "dye:orange 2",
	recipe = {
		{"cropocalypse:carrot"}
	},
})

minetest.register_craft({
	output = "dye:violet 2",
	recipe = {
		{"cropocalypse:potato"}
	},
})

minetest.register_craft({
	output = "dye:white 2",
	recipe = {
		{"cropocalypse:beet"}
	},
})

-- Adds Some New Glowing Mushrooms

-- Saucer Mushroom

minetest.register_node("cropocalypse:saucer_mushroom", {
	description = ("Saucer Mushroom"),
	tiles = {"cropocalypse_saucer_mushroom.png"},
	inventory_image = "cropocalypse_saucer_mushroom.png",
	wield_image = "cropocalypse_saucer_mushroom.png",
	drawtype = "plantlike",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {saucer_mushroom = 1, food_saucer_mushroom = 1, snappy = 3, attached_node = 1, flammable = 1},
	drop = "cropocalypse:saucer_mushroom",
	sounds = default.node_sound_leaves_defaults(),
	on_use = minetest.item_eat(4),
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, -1 / 16, 4 / 16},
	},
	light_source = 9,
})

minetest.register_decoration({
	name = "cropocalypse:saucer_mushroom",
	deco_type = "simple",
	place_on = {"default:dirt_with_rainforest_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 10, y = 10, z = 10},
		seed = 6649,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"rainforest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:saucer_mushroom",
})

function flowers.saucer_mushroom_spread(pos, node)
	if minetest.get_node_light(pos, 0.5) > 10 then
		if minetest.get_node_light(pos, nil) >= 11 then
			minetest.remove_node(pos)
		end
		return
	end
	local positions = minetest.find_nodes_in_area_under_air(
		{x = pos.x - 75, y = pos.y - 50, z = pos.z - 75},
		{x = pos.x + 75, y = pos.y + 50, z = pos.z + 75},
		{"default:stone_with_coal"})
	if #positions == 0 then
		return
	end
	local pos2 = positions[math.random(#positions)]
	pos2.y = pos2.y + 1
	if minetest.get_node_light(pos2, 0.5) <= 10 then
		minetest.set_node(pos2, {name = node.name})
	end
end

minetest.register_abm({
	label = "Saucer Mushroom Spread",
	nodenames = {"group:saucer_mushroom"},
	interval = 11,
	chance = 75,
	action = function(...)
		flowers.saucer_mushroom_spread(...)
	end,
})

-- Puffed Mushroom

minetest.register_node("cropocalypse:puffed_mushroom", {
	description = ("Puffed Mushroom"),
	tiles = {"cropocalypse_puffed_mushroom.png"},
	inventory_image = "cropocalypse_puffed_mushroom.png",
	wield_image = "cropocalypse_puffed_mushroom.png",
	drawtype = "plantlike",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {puffed_mushroom = 1, food_puffed_mushroom = 1, snappy = 3, attached_node = 1, flammable = 1},
	drop = "cropocalypse:puffed_mushroom",
	sounds = default.node_sound_leaves_defaults(),
	on_use = minetest.item_eat(4),
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, -1 / 16, 4 / 16},
	},
	light_source = 9,
})

minetest.register_decoration({
	name = "cropocalypse:puffed_mushroom",
	deco_type = "simple",
	place_on = {"default:dirt_with_rainforest_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 10, y = 10, z = 10},
		seed = 2343,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"rainforest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:puffed_mushroom",
})

function flowers.puffed_mushroom_spread(pos, node)
	if minetest.get_node_light(pos, 0.5) > 10 then
		if minetest.get_node_light(pos, nil) >= 11 then
			minetest.remove_node(pos)
		end
		return
	end
	local positions = minetest.find_nodes_in_area_under_air(
		{x = pos.x - 75, y = pos.y - 50, z = pos.z - 75},
		{x = pos.x + 75, y = pos.y + 50, z = pos.z + 75},
		{"default:stone_with_iron"})
	if #positions == 0 then
		return
	end
	local pos2 = positions[math.random(#positions)]
	pos2.y = pos2.y + 1
	if minetest.get_node_light(pos2, 0.5) <= 10 then
		minetest.set_node(pos2, {name = node.name})
	end
end

minetest.register_abm({
	label = "Puffed Mushroom Spread",
	nodenames = {"group:puffed_mushroom"},
	interval = 11,
	chance = 75,
	action = function(...)
		flowers.puffed_mushroom_spread(...)
	end,
})

-- Veiled Mushroom

minetest.register_node("cropocalypse:veiled_mushroom", {
	description = ("Veiled Mushroom"),
	tiles = {"cropocalypse_veiled_mushroom.png"},
	inventory_image = "cropocalypse_veiled_mushroom.png",
	wield_image = "cropocalypse_veiled_mushroom.png",
	drawtype = "plantlike",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {veiled_mushroom = 1, food_veiled_mushroom = 1, snappy = 3, attached_node = 1, flammable = 1},
	drop = "cropocalypse:veiled_mushroom",
	sounds = default.node_sound_leaves_defaults(),
	on_use = minetest.item_eat(4),
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, -1 / 16, 4 / 16},
	},
	light_source = 9,
})

minetest.register_decoration({
	name = "cropocalypse:veiled_mushroom",
	deco_type = "simple",
	place_on = {"default:dirt_with_rainforest_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 10, y = 10, z = 10},
		seed = 6712,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"rainforest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:veiled_mushroom",
})

function flowers.veiled_mushroom_spread(pos, node)
	if minetest.get_node_light(pos, 0.5) > 10 then
		if minetest.get_node_light(pos, nil) >= 11 then
			minetest.remove_node(pos)
		end
		return
	end
	local positions = minetest.find_nodes_in_area_under_air(
		{x = pos.x - 75, y = pos.y - 50, z = pos.z - 75},
		{x = pos.x + 75, y = pos.y + 50, z = pos.z + 75},
		{"default:stone_with_tin"})
	if #positions == 0 then
		return
	end
	local pos2 = positions[math.random(#positions)]
	pos2.y = pos2.y + 1
	if minetest.get_node_light(pos2, 0.5) <= 10 then
		minetest.set_node(pos2, {name = node.name})
	end
end

minetest.register_abm({
	label = "Veiled Mushroom Spread",
	nodenames = {"group:veiled_mushroom"},
	interval = 11,
	chance = 75,
	action = function(...)
		flowers.veiled_mushroom_spread(...)
	end,
})

-- Slimy Mushroom

minetest.register_node("cropocalypse:slimy_mushroom", {
	description = ("Slimy Mushroom"),
	tiles = {"cropocalypse_slimy_mushroom.png"},
	inventory_image = "cropocalypse_slimy_mushroom.png",
	wield_image = "cropocalypse_slimy_mushroom.png",
	drawtype = "plantlike",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {slimy_mushroom = 1, food_slimy_mushroom = 1, snappy = 3, attached_node = 1, flammable = 1},
	drop = "cropocalypse:slimy_mushroom",
	sounds = default.node_sound_leaves_defaults(),
	on_use = minetest.item_eat(4),
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, -1 / 16, 4 / 16},
	},
	light_source = 9,
})

minetest.register_decoration({
	name = "cropocalypse:slimy_mushroom",
	deco_type = "simple",
	place_on = {"default:dirt_with_rainforest_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 10, y = 10, z = 10},
		seed = 5567,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"rainforest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:slimy_mushroom",
})

function flowers.slimy_mushroom_spread(pos, node)
	if minetest.get_node_light(pos, 0.5) > 10 then
		if minetest.get_node_light(pos, nil) >= 11 then
			minetest.remove_node(pos)
		end
		return
	end
	local positions = minetest.find_nodes_in_area_under_air(
		{x = pos.x - 75, y = pos.y - 50, z = pos.z - 75},
		{x = pos.x + 75, y = pos.y + 50, z = pos.z + 75},
		{"default:stone_with_copper"})
	if #positions == 0 then
		return
	end
	local pos2 = positions[math.random(#positions)]
	pos2.y = pos2.y + 1
	if minetest.get_node_light(pos2, 0.5) <= 10 then
		minetest.set_node(pos2, {name = node.name})
	end
end

minetest.register_abm({
	label = "Slimy Mushroom Spread",
	nodenames = {"group:slimy_mushroom"},
	interval = 11,
	chance = 75,
	action = function(...)
		flowers.slimy_mushroom_spread(...)
	end,
})

-- King Mushroom

minetest.register_node("cropocalypse:king_mushroom", {
	description = ("King Mushroom"),
	tiles = {"cropocalypse_king_mushroom.png"},
	inventory_image = "cropocalypse_king_mushroom.png",
	wield_image = "cropocalypse_king_mushroom.png",
	drawtype = "plantlike",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {king_mushroom = 1, food_king_mushroom = 1, snappy = 3, attached_node = 1, flammable = 1},
	drop = "cropocalypse:king_mushroom",
	sounds = default.node_sound_leaves_defaults(),
	on_use = minetest.item_eat(4),
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, -1 / 16, 4 / 16},
	},
	light_source = 9,
})

minetest.register_decoration({
	name = "cropocalypse:king_mushroom",
	deco_type = "simple",
	place_on = {"default:dirt_with_rainforest_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 10, y = 10, z = 10},
		seed = 6031,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"rainforest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:king_mushroom",
})

function flowers.king_mushroom_spread(pos, node)
	if minetest.get_node_light(pos, 0.5) > 10 then
		if minetest.get_node_light(pos, nil) >= 11 then
			minetest.remove_node(pos)
		end
		return
	end
	local positions = minetest.find_nodes_in_area_under_air(
		{x = pos.x - 75, y = pos.y - 50, z = pos.z - 75},
		{x = pos.x + 75, y = pos.y + 50, z = pos.z + 75},
		{"default:stone_with_gold"})
	if #positions == 0 then
		return
	end
	local pos2 = positions[math.random(#positions)]
	pos2.y = pos2.y + 1
	if minetest.get_node_light(pos2, 0.5) <= 10 then
		minetest.set_node(pos2, {name = node.name})
	end
end

minetest.register_abm({
	label = "King Mushroom Spread",
	nodenames = {"group:king_mushroom"},
	interval = 11,
	chance = 75,
	action = function(...)
		flowers.king_mushroom_spread(...)
	end,
})

-- Melting Mushroom

minetest.register_node("cropocalypse:melting_mushroom", {
	description = ("Melting Mushroom"),
	tiles = {"cropocalypse_melting_mushroom.png"},
	inventory_image = "cropocalypse_melting_mushroom.png",
	wield_image = "cropocalypse_melting_mushroom.png",
	drawtype = "plantlike",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {melting_mushroom = 1, food_melting_mushroom = 1, snappy = 3, attached_node = 1, flammable = 1},
	drop = "cropocalypse:melting_mushroom",
	sounds = default.node_sound_leaves_defaults(),
	on_use = minetest.item_eat(4),
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, -1 / 16, 4 / 16},
	},
	light_source = 9,
})

minetest.register_decoration({
	name = "cropocalypse:melting_mushroom",
	deco_type = "simple",
	place_on = {"default:dirt_with_rainforest_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 10, y = 10, z = 10},
		seed = 7655,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"rainforest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:melting_mushroom",
})

function flowers.melting_mushroom_spread(pos, node)
	if minetest.get_node_light(pos, 0.5) > 10 then
		if minetest.get_node_light(pos, nil) >= 11 then
			minetest.remove_node(pos)
		end
		return
	end
	local positions = minetest.find_nodes_in_area_under_air(
		{x = pos.x - 75, y = pos.y - 50, z = pos.z - 75},
		{x = pos.x + 75, y = pos.y + 50, z = pos.z + 75},
		{"default:stone_with_diamond"})
	if #positions == 0 then
		return
	end
	local pos2 = positions[math.random(#positions)]
	pos2.y = pos2.y + 1
	if minetest.get_node_light(pos2, 0.5) <= 10 then
		minetest.set_node(pos2, {name = node.name})
	end
end

minetest.register_abm({
	label = "Melting Mushroom Spread",
	nodenames = {"group:melting_mushroom"},
	interval = 11,
	chance = 75,
	action = function(...)
		flowers.melting_mushroom_spread(...)
	end,
})

-- Magic Mushroom

minetest.register_node("cropocalypse:magic_mushroom", {
	description = ("Magic Mushroom"),
	tiles = {"cropocalypse_magic_mushroom.png"},
	inventory_image = "cropocalypse_magic_mushroom.png",
	wield_image = "cropocalypse_magic_mushroom.png",
	drawtype = "plantlike",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	groups = {magic_mushroom = 1, food_magic_mushroom = 1, snappy = 3, attached_node = 1, flammable = 1},
	drop = "cropocalypse:magic_mushroom",
	sounds = default.node_sound_leaves_defaults(),
	on_use = minetest.item_eat(4),
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, -1 / 16, 4 / 16},
	},
	light_source = 9,
})

minetest.register_decoration({
	name = "cropocalypse:magic_mushroom",
	deco_type = "simple",
	place_on = {"default:dirt_with_rainforest_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.1,
		spread = {x = 10, y = 10, z = 10},
		seed = 1930,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"rainforest"},
	y_max = 31000,
	y_min = 1,
	decoration = "cropocalypse:magic_mushroom",
})

function flowers.magic_mushroom_spread(pos, node)
	if minetest.get_node_light(pos, 0.5) > 10 then
		if minetest.get_node_light(pos, nil) >= 11 then
			minetest.remove_node(pos)
		end
		return
	end
	local positions = minetest.find_nodes_in_area_under_air(
		{x = pos.x - 75, y = pos.y - 50, z = pos.z - 75},
		{x = pos.x + 75, y = pos.y + 50, z = pos.z + 75},
		{"default:stone_with_mese"})
	if #positions == 0 then
		return
	end
	local pos2 = positions[math.random(#positions)]
	pos2.y = pos2.y + 1
	if minetest.get_node_light(pos2, 0.5) <= 10 then
		minetest.set_node(pos2, {name = node.name})
	end
end

minetest.register_abm({
	label = "Magic Mushroom Spread",
	nodenames = {"group:magic_mushroom"},
	interval = 11,
	chance = 75,
	action = function(...)
		flowers.magic_mushroom_spread(...)
	end,
})

-- Adds Cropocalypse Items As Dungeon Loot

if minetest.global_exists("dungeon_loot") then
	dungeon_loot.register({
		{name = "cropocalypse:carrot_seed", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:potato_seed", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:beet_seed", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:soybean_seed", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:garlic_seed", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:morel_mushroom_seed", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:oyster_mushroom_seed", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:shiitake_mushroom_seed", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:white_button_mushroom_seed", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:saucer_mushroom", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:puffed_mushroom", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:veiled_mushroom", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:slimy_mushroom", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:king_mushroom", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:melting_mushroom", chance = 0.3, count = {1, 4}},
		{name = "cropocalypse:magic_mushroom", chance = 0.3, count = {1, 4},
			types = {"normal"}},
	})
end

-- If The Bonemeal Mod Is Installed This Adds The Crops To Be Bonemealed

if minetest.get_modpath("bonemeal") then

	bonemeal:add_crop({
	{"cropocalypse:carrot_", 8, "cropocalypse:seed_carrot"},
	{"cropocalypse:potato_", 8, "cropocalypse:seed_potato"},
	{"cropocalypse:beet_", 8, "cropocalypse:seed_beet"},
	{"cropocalypse:soybean_", 8, "cropocalypse:seed_soybean"},
	{"cropocalypse:garlic_", 8, "cropocalypse:seed_garlic"},
	{"cropocalypse:morel_mushroom_", 8, "cropocalypse:seed_morel_mushroom"},
	{"cropocalypse:oyster_mushroom_", 8, "cropocalypse:seed_oyster_mushroom"},
	{"cropocalypse:shiitake_mushroom_", 8, "cropocalypse:seed_shiitake_mushroom"},
	{"cropocalypse:white_button_mushroom_", 8, "cropocalypse:seed_white_button_mushroom"}
	})
end