-- cropocalypse/crafting.lua

-- These Are The Crafting Recipes

-- Wooden Bowl

minetest.register_craftitem("cropocalypse:wooden_bowl", {
	description = ("Wooden Bowl"),
	inventory_image = "cropocalypse_wooden_bowl.png",
	groups = {flammable = 2},
})

minetest.register_craft({
	output = "cropocalypse:wooden_bowl 3",
	recipe = {
		{"group:wood", "", "group:wood"},
		{"", "group:wood", ""},
	}
})

-- Sliced Apples

minetest.register_craftitem("cropocalypse:sliced_apples", {
	description = ("Sliced Apples"),
	inventory_image = "cropocalypse_sliced_apples.png",
	on_use = minetest.item_eat(2),
	groups = {food_sliced_apples = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:sliced_apples 4",
	recipe = {"default:apple", "default:apple", "default:apple"}
})

-- Apple Cider Vinegar

minetest.register_craftitem("cropocalypse:apple_cider_vinegar", {
	description = ("Apple Cider Vinegar"),
	inventory_image = "cropocalypse_apple_cider_vinegar.png",
	on_use = minetest.item_eat(1),
	groups = {food_apple_cider_vinegar = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:apple_cider_vinegar",
	recipe = {"cropocalypse:sliced_apples", "cropocalypse:sliced_apples", "cropocalypse:sugar", "vessels:glass_bottle"}
})

-- Saltwater Kelp Jar

minetest.register_craftitem("cropocalypse:saltwater_kelp_jar", {
	description = ("Saltwater Kelp Jar"),
	inventory_image = "cropocalypse_saltwater_kelp_jar.png",
	on_use = minetest.item_eat(1),
	groups = {food_saltwater_kelp_jar = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:saltwater_kelp_jar",
	recipe = {"default:sand_with_kelp", "default:sand_with_kelp", "default:sand_with_kelp", "vessels:glass_bottle"}
})

-- Multiplying Saltwater Kelp Jars Because Kelp Is Not Currently Renewable

minetest.register_craftitem("cropocalypse:saltwater_kelp_jar", {
	description = ("Saltwater Kelp Jar"),
	inventory_image = "cropocalypse_saltwater_kelp_jar.png",
	on_use = minetest.item_eat(1),
	groups = {food_saltwater_kelp_jar = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:saltwater_kelp_jar 3",
	recipe = {"cropocalypse:saltwater_kelp_jar", "vessels:glass_bottle", "vessels:glass_bottle"}
})

-- Kelp Agar

minetest.register_craftitem("cropocalypse:kelp_agar", {
	description = ("Kelp Agar"),
	inventory_image = "cropocalypse_kelp_agar.png",
	on_use = minetest.item_eat(1),
	groups = {food_kelp_agar = 1, flammable = 1},
})

minetest.register_craft({
	type = "cooking",
	output = "cropocalypse:kelp_agar",
	recipe = "cropocalypse:saltwater_kelp_jar",
})

-- Sliced Carrots

minetest.register_craftitem("cropocalypse:sliced_carrots", {
	description = ("Sliced Carrots"),
	inventory_image = "cropocalypse_sliced_carrots.png",
	on_use = minetest.item_eat(2),
	groups = {food_sliced_carrots = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:sliced_carrots 2",
	recipe = {"cropocalypse:carrot", "cropocalypse:carrot", "cropocalypse:carrot"}
})

-- Mashed Potatoes

minetest.register_craftitem("cropocalypse:mashed_potatoes", {
	description = ("Mashed Potatoes"),
	inventory_image = "cropocalypse_mashed_potatoes.png",
	on_use = minetest.item_eat(4),
	groups = {food_mashed_potatoes = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:mashed_potatoes",
	recipe = {"cropocalypse:wooden_bowl", "cropocalypse:potato", "cropocalypse:potato", "cropocalypse:potato"}
})

-- Sugar

minetest.register_craftitem("cropocalypse:sugar", {
	description = ("Sugar"),
	inventory_image = "cropocalypse_sugar.png",
	on_use = minetest.item_eat(1),
	groups = {food_sugar = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:sugar 2",
	recipe = {"cropocalypse:beet", "cropocalypse:beet", "cropocalypse:beet"}
})

-- Soybean Water

minetest.register_craftitem("cropocalypse:soybean_water", {
	description = ("Soybean Water"),
	inventory_image = "cropocalypse_soybean_water.png",
	on_use = minetest.item_eat(1),
	groups = {food_soybean_water = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:soybean_water",
	recipe = {"cropocalypse:soybean", "cropocalypse:soybean", "cropocalypse:soybean", "vessels:glass_bottle"}
})

-- Soy Milk

minetest.register_craftitem("cropocalypse:soy_milk", {
	description = ("Soy Milk"),
	inventory_image = "cropocalypse_soy_milk.png",
	on_use = minetest.item_eat(4),
	groups = {food_soy_milk = 1, flammable = 1},
})

minetest.register_craft({
	type = "cooking",
	output = "cropocalypse:soy_milk",
	recipe = "cropocalypse:soybean_water",
})

-- Soy Butter

minetest.register_craftitem("cropocalypse:soy_butter", {
	description = ("Soy Butter"),
	inventory_image = "cropocalypse_soy_butter.png",
	on_use = minetest.item_eat(4),
	groups = {food_soy_butter = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:soy_butter",
	recipe = {"cropocalypse:wooden_bowl", "cropocalypse:soy_milk", "cropocalypse:apple_cider_vinegar", "cropocalypse:kelp_agar"}
})

-- Raw Garlic Bread

minetest.register_craftitem("cropocalypse:raw_garlic_bread", {
	description = ("Raw Garlic Bread"),
	inventory_image = "cropocalypse_raw_garlic_bread.png",
	on_use = minetest.item_eat(3),
	groups = {food_raw_garlic_bread = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:raw_garlic_bread",
	recipe = {"farming:bread", "cropocalypse:soy_butter", "cropocalypse:garlic"}
})

-- Cooked Garlic Bread

minetest.register_craftitem("cropocalypse:cooked_garlic_bread", {
	description = ("Cooked Garlic Bread"),
	inventory_image = "cropocalypse_cooked_garlic_bread.png",
	on_use = minetest.item_eat(8),
	groups = {food_cooked_garlic_bread = 1, flammable = 1},
})

minetest.register_craft({
	type = "cooking",
	output = "cropocalypse:cooked_garlic_bread",
	recipe = "cropocalypse:raw_garlic_bread",
})

-- Mushroom Surprise

minetest.register_craftitem("cropocalypse:mushroom_surprise", {
	description = ("Mushroom Surprise"),
	inventory_image = "cropocalypse_mushroom_surprise.png",
	on_use = minetest.item_eat(6),
	groups = {food_mushroom_surprise = 1, flammable = 1},
})

minetest.register_craft({
	type = "shapeless",
	output = "cropocalypse:mushroom_surprise",
	recipe = {"cropocalypse:wooden_bowl", "cropocalypse:morel_mushroom", "cropocalypse:oyster_mushroom", "cropocalypse:shiitake_mushroom", "cropocalypse:button_mushroom"}
})

-- Cropocalypse Dye Recipes

minetest.register_craft({
	output = "dye:orange 2",
	recipe = {
		{"cropocalypse:carrot"}
	},
})

minetest.register_craft({
	output = "dye:violet 2",
	recipe = {
		{"cropocalypse:potato"}
	},
})

minetest.register_craft({
	output = "dye:white 2",
	recipe = {
		{"cropocalypse:beet"}
	},
})