-- dynamic_trees/dt_world_generation.lua

-- Adds The Acacia Sapling To The Savanna
minetest.register_decoration({
	name = "Dynamic Trees Acacia Sapling",
	deco_type = "simple",
	place_on = {"group:soil","group:sand"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.2,
		spread = {x = 500, y = 500, z = 500},
		seed = 9633,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"savanna"},
	y_max = 31000,
	y_min = 1,
	decoration = "dynamic_trees:acacia_tree_sapling",
})

-- Adds The Apple Sapling To The Deciduous Forest And Grassland
minetest.register_decoration({
	name = "Dynamic Trees Apple Sapling",
	deco_type = "simple",
	place_on = {"group:soil","group:sand"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.15,
		spread = {x = 500, y = 500, z = 500},
		seed = 2486,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"deciduous_forest", "grassland"},
	y_max = 31000,
	y_min = 1,
	decoration = "dynamic_trees:apple_tree_sapling",
})

-- Adds The Aspen Sapling To The Deciduous Forest And Grassland
minetest.register_decoration({
	name = "Dynamic Trees Aspen Sapling",
	deco_type = "simple",
	place_on = {"group:soil","group:sand"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.15,
		spread = {x = 500, y = 500, z = 500},
		seed = 3927,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"deciduous_forest", "grassland"},
	y_max = 31000,
	y_min = 1,
	decoration = "dynamic_trees:aspen_tree_sapling",
})

-- Adds The Cactus Seedling To The Deserts
minetest.register_decoration({
	name = "Dynamic Trees Cactus Seedling",
	deco_type = "simple",
	place_on = {"group:soil","group:sand"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.15,
		spread = {x = 500, y = 500, z = 500},
		seed = 5238,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"desert", "sandstone_desert", "cold_desert"},
	y_max = 31000,
	y_min = 1,
	decoration = "dynamic_trees:cactus_seedling",
})

-- Adds The Pine Sapling To The Coniferous Forest And Tundra
minetest.register_decoration({
	name = "Dynamic Trees Pine Sapling",
	deco_type = "simple",
	place_on = {
		"group:soil", "group:sand", "default:permafrost_with_moss",
		"default:permafrost_with_stones"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.15,
		spread = {x = 500, y = 500, z = 500},
		seed = 2447,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"coniferous_forest", "tundra"},
	y_max = 31000,
	y_min = 1,
	decoration = "dynamic_trees:pine_tree_sapling",
})

-- Adds The Bamboo Shoot To The Rainforest And Deciduous Forest
minetest.register_decoration({
	name = "Dynamic Trees Bamboo Shoot",
	deco_type = "simple",
	place_on = {"group:soil","group:sand"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.2,
		spread = {x = 500, y = 500, z = 500},
		seed = 6566,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"rainforest", "deciduous_forest"},
	y_max = 31000,
	y_min = 1,
	decoration = "dynamic_trees:bamboo_shoot",
})

-- Adds The Dry Sapling To The Deserts
minetest.register_decoration({
	name = "Dynamic Trees Dry Tree Sapling",
	deco_type = "simple",
	place_on = {"group:soil","group:sand"},
	sidelen = 16,
	noise_params = {
		offset = -0.1,
		scale = 0.15,
		spread = {x = 500, y = 500, z = 500},
		seed = 3628,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"desert", "sandstone_desert", "cold_desert"},
	y_max = 31000,
	y_min = 1,
	decoration = "dynamic_trees:dry_tree_sapling",
})