
-- Translation support

local S

if minetest.get_translator ~= nil then
	S = minetest.get_translator("mob_mese_monster_classic") -- 5.x translation function
else
	S = function(str, ...) -- boilerplate function
		local args = {...}
		return str:gsub("@%d+", function(match)
			return args[tonumber(match:sub(2))]
		end)
	end
end

-- Mese Monster by Zeg9

mobs:register_mob("mob_mese_monster_classic:mese_monster", {
	type = "monster",
	passive = false,
	damage = 3,
	attack_type = "shoot",
	shoot_interval = 0.5,
	arrow = "mobs_monster:mese_arrow",
	shoot_offset = 2,
	hp_min = 10,
	hp_max = 25,
	armor = 80,
	collisionbox = {-0.5, -1.5, -0.5, 0.5, 0.5, 0.5},
	visual = "mesh",
	mesh = "zmobs_mese_monster.x",
	textures = {
		{"zmobs_mese_monster.png"},
	},
	blood_texture = "default_mese_crystal_fragment.png",
	makes_footstep_sound = false,
	sounds = {
		random = "mobs_mesemonster",
	},
	view_range = 10,
	walk_velocity = 0.5,
	run_velocity = 2,
	jump = true,
	jump_height = 8,
	fall_damage = 0,
	fall_speed = -6,
	stepheight = 2.1,
	drops = {
		{name = "default:mese_crystal", chance = 9, min = 0, max = 2},
		{name = "default:mese_crystal_fragment", chance = 1, min = 0, max = 2},
	},
	water_damage = 1,
	lava_damage = 1,
	light_damage = 0,
	animation = {
		speed_normal = 15,
		speed_run = 15,
		stand_start = 0,
		stand_end = 14,
		walk_start = 15,
		walk_end = 38,
		run_start = 40,
		run_end = 63,
		punch_start = 40,
		punch_end = 63,
	},
	arrow_override = function(self)
		self.velocity = 6
		self.damage = 3
	end
})

-- Spawn in world

mobs:spawn({
	name = "mob_mese_monster_classic:mese_monster",
	nodes = {"default:stone"},
	max_light = 7,
	chance = 5000,
	active_object_count = 1,
	max_height = -20,
})

-- Spawn egg

mobs:register_egg("mob_mese_monster_classic:mese_monster", S("Mese Monster Classic"),
		"default_mese_block.png", 1)

-- Mmese arrow (only if mobs_monster isn't found)

if not minetest.get_modpath("mobs_monster") then

	mobs:register_arrow(":mobs_monster:mese_arrow", {
		visual = "sprite",
		visual_size = {x = 0.5, y = 0.5},
		textures = {"default_mese_crystal_fragment.png"},
		velocity = 6,

		hit_player = function(self, player)
			player:punch(self.object, 1.0, {
				full_punch_interval = 1.0,
				damage_groups = {fleshy = 2},
			}, nil)
		end,

		hit_mob = function(self, player)
			player:punch(self.object, 1.0, {
				full_punch_interval = 1.0,
				damage_groups = {fleshy = 2},
			}, nil)
		end,

		hit_node = function(self, pos, node)
		end
	})

	-- add recipe 9x mese crystal fragments = 1x mese crystal

	local tmp = "default:mese_crystal_fragment"

	minetest.register_craft({
		output = "default:mese_crystal",
		recipe = {
			{tmp, tmp, tmp},
			{tmp, tmp, tmp},
			{tmp, tmp, tmp}
		}
	})
end


print ("[MOD] Mob Mese Monsters Classic loaded")
