
--[[
	Moon Flower mod by MirceaKitsune
	https://github.com/MirceaKitsune/minetest_mods_moonflower

	Additional features by TenPlus1
]]--

-- global

moonflower = {
	interval = tonumber(core.settings:get("moonflower_interval") or 60 * 5),
	transform = core.settings:get_bool("moonflower_transform") ~= false
}

-- translation and text colour

local S = core.get_translator("moonflower")
local text_col = core.get_color_escape_sequence("#68d2ff")

-- closed moonflower

core.register_node("moonflower:moonflower_closed", {
	description = S("Moon flower"),
	drawtype = "plantlike",
	tiles = { "moonflower_closed.png" },
	inventory_image = "moonflower_closed.png",
	wield_image = "moonflower_closed.png",
	sunlight_propagates = true,
	paramtype = "light",
	walkable = false,
	light_source = 4,
	groups = {snappy = 3, dig_immediate = 1, flammable = 2, eatable = 2},
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed", fixed = {-0.15, -0.5, -0.15, 0.15, 0.1, 0.15},
	},
	visual_scale = 0.6,

	on_use = function(itemstack, player, pointed_thing)

		player:override_day_night_ratio(1) -- see in darkness only on surface

		core.chat_send_player(player:get_player_name(),
				text_col .. S(">>> You can suddenly see much clearer in the moonlight!"))

		core.sound_play("default_place_node", {
				pitch = 1.4, pos = player:get_pos(), gain = 1.0,
				max_hear_distance = 5}, true)

		core.after(moonflower.interval, function(player)

			if player and player:get_pos() then

				player:override_day_night_ratio(nil) -- return to normal day/night vision

				core.chat_send_player(player:get_player_name(),
						text_col .. S(">>> Your vision returns to normal!"))

				core.sound_play("default_place_node", {
						pitch = 1.2, pos = player:get_pos(), gain = 1.0,
						max_hear_distance = 5}, true)
			end
		end, player)

		return core.do_item_eat(2, nil, itemstack, player, pointed_thing)
	end
})

-- open moonflower

core.register_node("moonflower:moonflower_open", {
	description = S("Moon flower"),
	drawtype = "plantlike",
	tiles = { "moonflower_open.png" },
	inventory_image = "moonflower_open.png",
	wield_image = "moonflower_open.png",
	paramtype = "light",
	sunlight_propagates = true,
	paramtype = "light",
	walkable = false,
	light_source = 10,
	groups = {not_in_creative_inventory = 1, snappy = 3, dig_immediate = 1, flammable = 2},
	drop = "moonflower:moonflower_closed",
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
		type = "fixed", fixed = {-0.15, -0.5, -0.15, 0.15, 0.1, 0.15},
	},
	visual_scale = 0.6
})

-- transform item list

local item_list = {
	{"default:gold_lump", "default:gold_ingot"},
	{"default:copper_lump", "default:copper_ingot"},
	{"default:iron_lump", "pigiron:iron_ingot"},
	{"pigiron:iron_charcoal_mix", "default:steel_ingot"},
	{"moreores:silver_lump", "moreores:silver_ingot"},
	{"moreores:mithril_lump", "moreores:mithril_ingot"},
	{"nether:nether_lump", "nether:nether_ingot"},
	{"default:tin_lump", "default:tin_ingot"},
	{"lapis:pyrite_lump", "lapis:pyrite_ingot"},
	{"bucket:bucket_water", "bucket:bucket_river_water"},
	{"ethereal:charcoal_lump", "default:coal_lump"},
	{"default:clay_lump", "default:clay_brick"},
	{"ethereal:fire_dust 2", "ethereal:etherium_dust"}
}

-- global functions to add to or clear list

function moonflower.transform_item(from_item, to_item)
	table.insert(item_list, {from_item, to_item})
end

function moonflower.clear_items()
	item_list = {}
end

-- particle effect helper

local function particle_effect(pos)

	core.add_particlespawner({
		amount = 10,
		time = 0.15,
		minpos = {x = pos.x - 0.2, y = pos.y - 0,   z = pos.z - 0.2},
		maxpos = {x = pos.x + 0.2, y = pos.y + 0.2, z = pos.z + 0.2},
		minvel = {x = -0.5, y = 0.5, z = -0.5},
		maxvel = {x =  0.5, y = 1.5, z =  0.5},
		minacc = {x = 0, y = 0.1, z = 0},
		maxacc = {x = 0, y = 0.2, z = 0},
		minexptime = 0.5,
		maxexptime = 1.3,
		minsize = .2,
		maxsize = .8,
		texture = "tnt_smoke.png",
		glow = 7
	})
end

-- Abm to open/close moonflower and do transformations

core.register_abm({
	nodenames = {"moonflower:moonflower_closed", "moonflower:moonflower_open"},
	interval = 11,
	chance = 1,
	catch_up = false,

	action = function(pos, node)

		local tod = core.get_timeofday()

		-- choose the appropriate form of the moon flower
		if node.name == "moonflower:moonflower_open"
		and (tod > 0.2 and tod < 0.8) then

			core.swap_node(pos, {name = "moonflower:moonflower_closed"})

		elseif node.name == "moonflower:moonflower_closed"
		and (tod > 0.8 or tod < 0.2)
		and core.get_node_light(pos, 0.5) == 15 then

			core.swap_node(pos, {name = "moonflower:moonflower_open"})
		end

		-- transform ingots back into ores
		if moonflower.transform and node.name == "moonflower:moonflower_open" then

			for _, ob in pairs(core.get_objects_inside_radius(pos, 0.5)) do

				local ent = ob:get_luaentity()

				if ent and ent.name == "__builtin:item" then

					for n = 1, #item_list do

						if ent.itemstring == item_list[n][1] then

							local pos2 = ob:get_pos()

							local obj2 = core.add_item(pos2, item_list[n][2])
							
							if obj2 then

								particle_effect(pos2)

								obj2:set_velocity({
									x = math.random() - 0.5,
									y = 4,
									z = math.random() - 0.5
								})
							end

							core.sound_play("default_place_node", {
									pitch = 1.6, pos = pos2,
									gain = 0.5, max_hear_distance = 5}, true)

							ob:remove() ; return -- only do 1 item every turn
						end
					end
				end
			end
		end
	end
})

-- craft into blue dye

core.register_craft( {
	output = "dye:blue 4",
	recipe = {{"moonflower:moonflower_closed"}}
})

-- add to mapgen

core.register_decoration({
	name = "moonflower:moonflower_closed",
	deco_type = "simple",
	place_on = {"group:soil", "default:dirt_with_snow"},
	sidelen = 80, fill_ratio = 0.0005,
	y_min = 1, y_max = 200,
	decoration = "moonflower:moonflower_closed",
	spawn_by = {"group:tree", "ethereal:bamboo"}, num_spawn_by = 1
})

-- lucky blocks

if core.get_modpath("lucky_block") then

	lucky_block:add_blocks({
		{"dro", {"moonflower:moonflower_closed"}, 1}
	})
end
