# Not So Simple Mobs

(C) 2016 NPX Team and Contributors , GPLv3

NSSM adds a wide variety of very hostile mobs, as well as new weapons, armours and foods.

This mod is a continuation of NPX Team's Not So Simple Mobs. Notes from the original README are available below.

## License

* License for the code: `GPLv3 or later`
    * see [LICENSE.txt](LICENSE.txt) and [license_notes.md](license_notes.md) for info on the license update
    * Copyright NPX Team and contributors
* License for non-code assets: see `LICENSE_MEDIA.txt`

## Version Dependencies

This mod relies heavily on the features in TenPlus1's [`mobs_redo`](https://notabug.org/tenplus1/mobs_redo), which is developed independently.

This version of NSSM was adjusted to run against commit `487e037cc9` (from 2018-12-20). If you are having problems with mod compatibility, please ensure you are using a version of `mobs_redo` close to that commit.

For some NSSB mobs, there is a dependency on the `3d_armor` API itself. This mod has been adjusted to work with version at tag `version-0.4.12` (June 2018) ; most later versions should work too.

## Settings

This mod provides some extra settings for fine tuning the experience:

* `nssm.classic_rainbow_staff` - Rainbow Staff is a powerful tool instead of a block placer
* `nssm.spiders_litter_web` - Allows spiders to place webs all over

## The original notes from NPX Team ! --¬

We suggest that you play nssm with:

* [`NSSB`](https://github.com/taikedz-mt/nssb) (Not So Simple Buildings, NPX Team's second mod that adds many blocks and Morlendor, the new dimension!)
* `3d_armors` (with which you can use nssm armors):
* `unified_inventory` (useful to discover all the new recipes and to use the armors):
* a throwing mod (a mod that add bows) if compatible with the Tenplus1's `damage_system`

We would like to thank:

* PilzAdam, for his wonderful simple-mobs mod;
* Tenplus1, for his hard work in making `mobs_redo`;
* Echoes91, for Spears: simple but amazing;
* and obviously Celeron-55 and all the people who contributed to Minetest and its community (and Paramat in particular);
* Denise and `Ponzi_Duro` for the revision of the guide;
* `Double_P`, `Ponzi_Duro`, `Andrey01` and `Taikedz` for the beta testing;

The mod makes the game really hard, please read the wiki before playing: <http://wiki.minetest.net/Mods/Not_So_Simple_Mobs> (which will be updated as soon as possible) or the old guide for the 2.4 version.

Here are the trailers of the mod:

* nssm 2.1: <https://www.youtube.com/watch?v=ccLUt58mo0k>
* nssm 3.0: <https://www.youtube.com/watch?v=ZBuAi1sQJxQ>

NPX Team ~
