
-- crystalgas arrow

mobs:register_arrow("nssm:crystal_gas_arrow", {
	visual = "sprite",
	visual_size = {x = 1, y = 1},
	textures = {"crystal_arrow.png"},
	velocity = 8,

	hit_player = function(self, player)
		crystal_gas_explosion(player:get_pos())
	end,

	hit_node = function(self, pos, node)
		crystal_gas_explosion(pos)
	end
})


function crystal_gas_explosion(pos)

	if core.is_protected(pos, "") then
		return
	end

	for dx = 0, 0 do
		for dy = -1, 2 do
			for dz = 0, 0 do

				local p = {x = pos.x + dx, y = pos.y + dy, z = pos.z + dz}

				if core.is_protected(p, "") then
					return
				end

				local n = core.get_node(p).name

				if n == "air" then
					core.set_node(p, {name = "nssm:crystal_gas"})
				end
			end
		end
	end
end

-- Pumpkid bomb

mobs:register_arrow("nssm:pumpkid_bomb", {
	visual = "cube",
	visual_size = {x = 1, y = 1},
	textures = {
		"pumpbomb_top.png", "pumpbomb_bottom.png", "pumpbomb_side.png",
		"pumpbomb_side.png", "pumpbomb_side.png", "pumpbomb_front.png"
	},
	velocity = 8,

	hit_player = function(self, player)

		local p = player:get_pos()

		if not core.is_protected(p, "")
		or not core.get_item_group(core.get_node(p).name, "unbreakable") == 1 then

			tnt.boom(p, {damage_radius = 3,radius = 2,ignore_protection = false})
		end
	end,

	hit_node = function(self, pos, node)

		if not core.is_protected(pos, "")
		or not core.get_item_group(core.get_node(pos).name, "unbreakable") == 1 then

			tnt.boom(pos, {damage_radius = 3,radius = 2,ignore_protection = false})
		end
	end
})

-- Lava_block bomb

mobs:register_arrow("nssm:lava_block_bomb", {
	visual = "cube",
	visual_size = {x = 1, y = 1},
	textures = {
		"default_lava.png", "default_lava.png", "default_lava.png",
		"default_lava.png", "default_lava.png", "default_lava.png"
	},
	velocity = 8,

	hit_player = function(self, player)

		local p = player:get_pos()

		if not core.is_protected(p, "")
		or not core.get_item_group(core.get_node(p).name, "unbreakable") == 1 then

			core.set_node(p, {name = "default:lava_source"})
		end
	end,

	hit_node = function(self, pos, node)

		if not core.is_protected(pos, "")
		or not core.get_item_group(core.get_node(pos).name, "unbreakable") == 1 then

			core.set_node(pos, {name = "default:lava_source"})
		end
	end
})

