
-- translation support

local S = core.get_translator("real_torch")

-- flood helper function

local function on_flood(pos, oldnode, newnode)

	-- drop as unlit torch
	core.add_item(pos, ItemStack("real_torch:torch 1"))

	-- return if torch is unlit already
	if oldnode.name:find("real_torch:") then
		return false
	end

	local def = core.registered_items[newnode.name]

	-- play extinquish sound if lit torch put out by water
	if def and def.groups and def.groups.water and def.groups.water > 0 then

		core.sound_play("default_cool_lava",
				{pos = pos, max_hear_distance = 10, gain = 0.1}, true)
	end

	-- Remove the torch node
	return false
end

-- unlit floor torch

core.register_node("real_torch:torch", {
	description = S("Unlit Torch"),
	drawtype = "mesh",
	mesh = "torch_floor.obj",
	inventory_image = "real_torch_on_floor.png",
	wield_image = "real_torch_on_floor.png",
	tiles = {
		{
			name = "real_torch_on_floor.png",
			animation = {
				type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 3.3
			}
		}
	},
	use_texture_alpha = "clip",
	paramtype = "light",
	paramtype2 = "wallmounted",
	light_source = 3,
	sunlight_propagates = true,
	walkable = false,
	liquids_pointable = false,
	groups = {choppy = 2, dig_immediate = 3, flammable = 1, attached_node = 1},
	drop = "real_torch:torch",
	selection_box = {
		type = "wallmounted", wall_bottom = {-1/8, -1/2, -1/8, 1/8, 2/16, 1/8}
	},
	sounds = default.node_sound_wood_defaults(),

	on_place = function(itemstack, placer, pointed_thing)

		local under = pointed_thing.under
		local node = core.get_node(under)
		local def = core.registered_nodes[node.name]

		if def and def.on_rightclick
		and not (placer and placer:is_player()
		and placer:get_player_control().sneak) then

			return def.on_rightclick(under, node, placer, itemstack,
					pointed_thing) or itemstack
		end

		local above = pointed_thing.above
		local wdir = core.dir_to_wallmounted(vector.subtract(under, above))
		local fakestack = itemstack

		if wdir == 0 then
			fakestack:set_name("real_torch:torch_ceiling")
		elseif wdir == 1 then
			fakestack:set_name("real_torch:torch")
		else
			fakestack:set_name("real_torch:torch_wall")
		end

		itemstack = core.item_place(fakestack, placer, pointed_thing, wdir)
		itemstack:set_name("real_torch:torch")

		return itemstack
	end,

	on_ignite = function(pos, igniter)

		local nod = core.get_node(pos)

		core.set_node(pos, {name = "default:torch", param2 = nod.param2})
	end,

	floodable = true, on_rotate = false, on_flood = on_flood
})

-- unlit wall torch

core.register_node("real_torch:torch_wall", {
	drawtype = "mesh",
	mesh = "torch_wall.obj",
	tiles = {
		{
			name = "real_torch_on_floor.png",
			animation = {
				type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 3.3
			}
		}
	},
	use_texture_alpha = "clip",
	paramtype = "light",
	paramtype2 = "wallmounted",
	light_source = 3,
	sunlight_propagates = true,
	walkable = false,
	groups = {
		choppy = 2, dig_immediate = 3, flammable = 1, not_in_creative_inventory = 1,
		attached_node = 1
	},
	drop = "real_torch:torch",
	selection_box = {
		type = "wallmounted", wall_side = {-1/2, -1/2, -1/8, -1/8, 1/8, 1/8}
	},
	sounds = default.node_sound_wood_defaults(),

	on_ignite = function(pos, igniter)

		local nod = core.get_node(pos)

		core.set_node(pos, {name = "default:torch_wall", param2 = nod.param2})
	end,

	floodable = true, on_rotate = false, on_flood = on_flood
})

-- unlit ceiling torch

core.register_node("real_torch:torch_ceiling", {
	drawtype = "mesh",
	mesh = "torch_ceiling.obj",
	tiles = {
		{
			name = "real_torch_on_floor.png",
			animation = {
				type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 3.3
			}
		}
	},
	use_texture_alpha = "clip",
	paramtype = "light",
	paramtype2 = "wallmounted",
	light_source = 3,
	sunlight_propagates = true,
	walkable = false,
	groups = {
		choppy = 2, dig_immediate = 3, flammable = 1, not_in_creative_inventory = 1,
		attached_node = 1
	},
	drop = "real_torch:torch",
	selection_box = {
		type = "wallmounted", wall_top = {-1/8, -1/16, -5/16, 1/8, 1/2, 1/8}
	},
	sounds = default.node_sound_wood_defaults(),

	on_ignite = function(pos, igniter)

		local nod = core.get_node(pos)

		core.set_node(pos, {name = "default:torch_ceiling", param2 = nod.param2})
	end,

	floodable = true, on_rotate = false, on_flood = on_flood
})

-- burnout helper function

local function torch_override(name)

	-- override default torch to burn out after 8-10 minutes and drop in water
	core.override_item("default:" .. name, {

		on_timer = function(pos, elapsed)

			local p2 = core.get_node(pos).param2

			core.set_node(pos, {name = "real_torch:" .. name, param2 = p2})

			core.sound_play("real_torch_burnout",
					{pos = pos, gain = 0.1, max_hear_distance = 10}, true)
		end,

		on_construct = function(pos)

			core.get_node_timer(pos):start(
					math.random(real_torch.min_duration, real_torch.max_duration))
		end,

		on_flood = on_flood
	})
end

torch_override("torch")
torch_override("torch_wall")
torch_override("torch_ceiling")
