
if core.has_feature("wallmounted_rotate") then -- 5.9 found

	local timer = 0
	local pl = {}

	minetest.register_globalstep(function(dtime)

		timer = timer + dtime ; if timer < 0.5 then return end ; timer = 0

		for _, player in pairs(minetest.get_connected_players()) do

			local attach = player:get_attach()
			local controls = player:get_player_control()
			local pos = player:get_pos() ; pos.y = pos.y + 0.1
			local def = minetest.registered_nodes[minetest.get_node(pos).name]
			local name = player:get_player_name()

			if controls.up and not attach
			and def and def.groups and def.groups.water then

				core.add_particle({
					amount = 1,
					expirationtime = 0.5,
					pos = pos,
					texture = "bubble.png",
					glow = 2,
					collisiondetection = false
				})

				if not pl[name] then -- flip body horizontally face down

					player:set_bone_override("Body", {
						rotation = {vec = {x = -1.57, y = 0, z = 0},
						interpolation = 0.09}
					})

					pl[name] = true
				end
			else
				if pl[name] then -- reset back to standing

					player:set_bone_override("Body")

					pl[name] = nil
				end
			end
		end
	end)
end
