---
--- Generated by EmmyLua(https://github.com/EmmyLua)
--- Created by jekyl.
--- DateTime: 4/25/2021 3:38 PM
---
--[[

Copyright © 2016 F. Georget <fabien.georget@gmail.com>
This work is free. You can redistribute it and/or modify it under the
terms of the Do What The Fuck You Want To Public License, Version 2,
as published by Sam Hocevar. See the COPYING file for more details.

--]]

-- the namespace that contains the useful functions and data
mixer = {}
grinder = {}

-- the ui
grinder.formspec = [[
	size[8,7;]

	list[context;recipe;2,1;1,1]

	list[context;input;1,2;1,1]
	button[2,2;1,1;grind;Grind]
	list[context;output;3,2;3,1]

	list[current_player;main;0,3.25;8,4;]
]]

-- This is a first filter to know if something can be crafted or not
grinder.filter_recipe = function(inv)
    if inv:is_empty("input")
    then
        return false
    else
        return true
    end
    return false
end


grinder.recipes = {
    {"alchemy:zap", "alchemy:zap_powder"},
    {"alchemy:sol", "alchemy:sol_powder"},
    {"alchemy:lunar", "alchemy:lunar_powder"},
    {"alchemy:hemlock", "alchemy:hemlock_powder"},
    {"alchemy:fractalized", "alchemy:fractalized_powder"},
    {"alchemy:life","alchemy:life_powder"},
    {"alchemy:oceanic_flower", "alchemy:oceanic_powder"},
}

-- Declares the recipes available
grinder.is_recipe = function(inv)
    local input = inv:get_stack("input", 1)

    local name = input:get_name()

    for _, r in pairs(grinder.recipes) do
        rin, rout = unpack(r)
        if (name == rin) then
            inv:set_list("recipe", {ItemStack(rout)})
            return
        end
    end
end

-- Build the UI
grinder.on_construct = function(pos)
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    inv:set_size("input", 1)
    inv:set_size("output", 3)
    inv:set_size("recipe", 1)
    meta:set_string("infotext", "Powder grinder")
    meta:set_string("formspec", grinder.formspec)

end


-- Nothing can be put by the user in the recipe and the output
grinder.put = function(_, listname, _, stack)
    if ( listname == "output" or listname == "recipe")
    then
        return 0
    else
        return stack:get_count()
    end
end


-- Refresh the "recipe" when a new item is put in the mixer
grinder.on_put = function(pos, _, _, _)
    local inv = minetest.get_meta(pos):get_inventory()
    if (grinder.filter_recipe(inv)) then
        grinder.is_recipe(inv)
    else
        inv:set_list("recipe", {ItemStack("")})
    end
end

-- You can't take the item from recipe
grinder.take = function(pos, listname, index, stack)
    if listname == "recipe" then
        return 0
    else
        return stack:get_count()
    end
end

-- Grind the ingredient into a powder
grinder.grind = function(pos)
    local inv = minetest.get_meta(pos):get_inventory()

    if inv:is_empty("recipe") then
        return
    end

    local out = inv:get_stack("recipe", 1)
    if not inv:room_for_item("output", out) then
        return
    end

    -- It's ok to mix, let's go

    local input = inv:get_stack("input", 1)
    input:take_item(1)
    inv:set_stack("input", 1, input)

    inv:add_item("output", out)

    -- Refresh
    grinder.on_put(pos, _, _, _)

end

-- Act when a field is received
grinder.on_grind = function(pos, _, fields)
    if fields.grind then
        grinder.grind(pos)
    end
end

-- refresh
grinder.on_take = function(pos, listname, index, stack)
    local inv = minetest.get_meta(pos):get_inventory()

    if    listname == "input"
    then
        grinder.on_put(pos, listname, index, stack)
    end
end

minetest.register_node("alchemy:powder_grinder", {
    description = "Powder grinder",
    drawtype="normal",
    tiles = {
        "alchemy_grinder_up.png",
        "alchemy_grinder_up.png",
        "alchemy_grinder_side.png",
        "alchemy_grinder_side.png",
        "alchemy_grinder_side.png",
        "alchemy_grinder_side.png",
    },
    is_ground_content = true,
    groups = {cracky=3, oddly_breakable_by_hand=1},
    inventory=true,
    on_construct                  = grinder.on_construct,
    allow_metadata_inventory_put  = grinder.put,
    on_metadata_inventory_put     = grinder.on_put,
    allow_metadata_inventory_take = grinder.take,
    on_metadata_inventory_take    = grinder.on_take,
    on_receive_fields             = grinder.on_grind

})

minetest.register_craft({
    output = "alchemy:powder_grinder",
    recipe = {
        {"default:copper_ingot", "default:copper_ingot", "default:copper_ingot"},
        {"default:steel_ingot", "default:diamond", "default:steel_ingot"},
        {"default:cobble", "default:steel_ingot", "default:cobble"}
    }
})
